import { capitalize } from "@scalar/helpers/string/capitalize";
import { camelToTitleWords } from "@scalar/helpers/string/camel-to-title";
import { parseLocalStorage } from "../../migrations/local-storage.js";
const migrate_v_2_1_0 = (data) => {
  console.info("Performing data migration v-0.0.0 to v-2.1.0");
  const oldData = {
    ...data,
    // @ts-expect-error Tags used to be called folders
    folders: parseLocalStorage("folder")
  };
  const flattenChildren = (childUids) => childUids.reduce(
    (prev, uid) => {
      const request = oldData.requests[uid];
      if (request) {
        prev.requestUids.add(uid);
        request.securitySchemeUids?.forEach((s) => prev.authUids.add(s));
      } else if (oldData.folders[uid]) {
        const { requestUids, tagUids, authUids } = flattenChildren(oldData.folders[uid].childUids ?? []);
        prev.tagUids.add(uid);
        requestUids.forEach((r) => prev.requestUids.add(r));
        tagUids.forEach((t) => prev.tagUids.add(t));
        authUids.forEach((a) => prev.authUids.add(a));
      }
      return prev;
    },
    {
      requestUids: /* @__PURE__ */ new Set(),
      tagUids: /* @__PURE__ */ new Set(),
      authUids: /* @__PURE__ */ new Set()
    }
  );
  const migrateAuth = (scheme) => {
    if (scheme.type === "apiKey") {
      return { type: "apiKey", name: scheme.name, value: scheme.value ?? "" };
    }
    if (scheme.type === "http") {
      return {
        type: "http",
        username: scheme.value ?? "",
        password: scheme.secondValue ?? "",
        token: scheme.value ?? ""
      };
    }
    if (scheme.type === "oauth2" && scheme.flow.type === "implicit") {
      return {
        type: "oauth-implicit",
        token: scheme.flow.token ?? ""
      };
    }
    if (scheme.type === "oauth2" && scheme.flow.type === "password") {
      return {
        type: "oauth-password",
        token: scheme.flow.token ?? "",
        username: scheme.flow.value ?? "",
        password: scheme.flow.secondValue ?? "",
        clientSecret: scheme.flow.clientSecret ?? ""
      };
    }
    if (scheme.type === "oauth2" && scheme.flow.type === "clientCredentials") {
      return {
        type: "oauth-clientCredentials",
        token: scheme.flow.token ?? "",
        clientSecret: scheme.flow.clientSecret ?? ""
      };
    }
    if (scheme.type === "oauth2" && scheme.flow.type === "authorizationCode") {
      return {
        type: "oauth-authorizationCode",
        token: scheme.flow.token ?? "",
        clientSecret: scheme.flow.clientSecret ?? ""
      };
    }
    return {
      type: "apiKey",
      name: "",
      value: ""
    };
  };
  const requestSecurityDict = {};
  const collections = Object.values(oldData.collections ?? {}).reduce((prev, c) => {
    const { requestUids, tagUids, authUids } = flattenChildren(c.childUids ?? []);
    const securitySchemesSet = /* @__PURE__ */ new Set([...authUids, ...Object.values(c.securitySchemeDict ?? {})]);
    const securitySchemes2 = [...securitySchemesSet];
    requestUids.forEach((r) => requestSecurityDict[r] = securitySchemes2);
    const auth = securitySchemes2.reduce(
      (_prev, uid) => {
        const scheme = oldData.securitySchemes[uid];
        if (scheme?.uid && _prev) {
          _prev[uid] = migrateAuth(scheme);
        }
        return _prev;
      },
      {}
    );
    prev[c.uid] = {
      "type": "collection",
      "openapi": c.spec?.openapi || "3.1.0",
      "info": c.spec?.info || { title: "OpenAPI Spec", version: "0.0.1" },
      "security": c.spec?.security || [],
      "externalDocs": c.spec?.externalDocs,
      "uid": c.uid,
      securitySchemes: securitySchemes2,
      "selectedSecuritySchemeUids": [],
      "selectedServerUid": c.selectedServerUid || c.spec?.serverUids?.[0] || "",
      "servers": c.spec?.serverUids || [],
      "requests": [...requestUids],
      "tags": [...tagUids],
      auth,
      "children": c.childUids || [],
      "x-scalar-icon": "interface-content-folder",
      "watchMode": false,
      "watchModeStatus": "IDLE"
    };
    return prev;
  }, {});
  const cookies = oldData.cookies ?? {};
  const environments = Object.values(oldData.environments ?? {}).reduce(
    (prev, e) => {
      prev[e.uid] = {
        ...e,
        value: e.raw ?? ""
      };
      return prev;
    },
    {}
  );
  const requests = Object.values(oldData.requests ?? {}).reduce((prev, r) => {
    const parameters = [
      ...Object.values(r.parameters?.path ?? {}),
      ...Object.values(r.parameters?.query ?? {}),
      ...Object.values(r.parameters?.headers ?? {}),
      ...Object.values(r.parameters?.cookies ?? {})
    ].filter((p) => p);
    const selectedSecuritySchemeUids = (r.selectedSecuritySchemeUids || []).filter(
      (s) => requestSecurityDict[r.uid]?.includes(s)
    );
    prev[r.uid] = {
      ...r,
      parameters,
      type: "request",
      method: r.method?.toLowerCase() ?? "get",
      examples: r.childUids || [],
      selectedSecuritySchemeUids,
      selectedServerUid: "",
      servers: []
    };
    return prev;
  }, {});
  const requestExamples = Object.values(oldData.requestExamples ?? {}).reduce(
    (prev, e) => {
      prev[e.uid] = {
        ...e,
        type: "requestExample"
      };
      return prev;
    },
    {}
  );
  const migrateFlow = (flow) => {
    const base = {
      refreshUrl: flow.refreshUrl || "",
      selectedScopes: flow.selectedScopes || [],
      scopes: flow.scopes || {}
    };
    if (flow.type === "implicit") {
      return {
        ...flow,
        ...base,
        "type": "implicit",
        "x-scalar-redirect-uri": ("redirectUri" in flow ? flow.redirectUri : "") || ""
      };
    }
    if (flow.type === "password") {
      return {
        ...flow,
        ...base,
        tokenUrl: flow.tokenUrl || ""
      };
    }
    if (flow.type === "clientCredentials") {
      return {
        ...flow,
        ...base,
        tokenUrl: flow.tokenUrl || ""
      };
    }
    return {
      ...flow,
      ...base,
      "x-usePkce": "no",
      "x-scalar-redirect-uri": ("redirectUri" in flow ? flow.redirectUri : "") || "",
      "authorizationUrl": flow.authorizationUrl || "",
      "tokenUrl": flow.tokenUrl || ""
    };
  };
  const getNameKey = (scheme) => {
    switch (scheme?.type) {
      case "apiKey":
        return `${capitalize(scheme.in)}`;
      case "http": {
        return `${capitalize(scheme.scheme)} Authentication`;
      }
      case "oauth2":
        return camelToTitleWords(scheme.flow.type);
      case "openIdConnect":
        return "Open ID Connect";
      default:
        return "None";
    }
  };
  const securitySchemes = Object.values(oldData.securitySchemes ?? {}).reduce(
    (prev, s) => {
      prev[s.uid] = s.type === "oauth2" ? {
        ...s,
        "nameKey": getNameKey(s),
        "x-scalar-client-id": s.clientId || "",
        "flow": migrateFlow(s.flow)
      } : { ...s, nameKey: getNameKey(s) };
      return prev;
    },
    {}
  );
  const servers = Object.values(oldData.servers ?? {}).reduce((prev, s) => {
    prev[s.uid] = {
      ...s,
      variables: s.variables ?? {}
    };
    return prev;
  }, {});
  const tags = Object.values(oldData.folders ?? {}).reduce((prev, f) => {
    prev[f.uid] = {
      "type": "tag",
      "uid": f.uid,
      "name": f.name || "unknownTag",
      "description": f.description,
      "children": f.childUids || [],
      "x-scalar-children": []
    };
    return prev;
  }, {});
  const workspaces = Object.values(oldData.workspaces ?? {}).reduce((prev, w) => {
    prev[w.uid] = {
      ...w,
      description: w.description ?? "Basic Scalar Workspace",
      cookies: w.cookieUids || [],
      collections: w.collectionUids || [],
      environments: w.environmentUids || []
    };
    return prev;
  }, {});
  return {
    collections,
    cookies,
    environments,
    requestExamples,
    requests,
    securitySchemes,
    servers,
    tags,
    workspaces
  };
};
export {
  migrate_v_2_1_0
};
//# sourceMappingURL=migration.js.map
