const migrate_v_2_4_0 = (data) => {
  console.info("Performing data migration v-2.3.0 to v-2.4.0");
  const collections = Object.values(data.collections).reduce((prev, c) => {
    if (c.info?.title === "Drafts") {
      c.servers = [];
      Object.values(data.requests).forEach((request) => {
        if (request.selectedServerUid && c.requests.includes(request.uid)) {
          const server = data.servers[request.selectedServerUid];
          if (server) {
            request.path = `${server.url}${request.path}`;
          }
          request.selectedServerUid = "";
        }
      });
    }
    prev[c.uid] = c;
    return prev;
  }, {});
  return {
    ...data,
    collections
  };
};
export {
  migrate_v_2_4_0
};
//# sourceMappingURL=migration.js.map
