const migrate_v_2_5_0 = (data) => {
  console.info("Performing data migration v-2.4.0 to v-2.5.0");
  const cookies = Object.entries(data.cookies || {}).reduce((acc, [key, cookie]) => {
    acc[key] = {
      ...cookie,
      uid: cookie.uid
    };
    return acc;
  }, {});
  const collections = Object.entries(data.collections || {}).reduce(
    (acc, [key, collection]) => {
      acc[key] = {
        ...collection,
        info: collection.info ?? {
          title: "API",
          version: "1.0"
        },
        uid: collection.uid,
        selectedSecuritySchemeUids: collection.selectedSecuritySchemeUids,
        servers: collection.servers.map((uid) => uid),
        tags: collection.tags.map((uid) => uid),
        requests: collection.requests.map((uid) => uid),
        children: collection.children.map((uid) => uid),
        selectedServerUid: collection.selectedServerUid,
        useCollectionSecurity: false
      };
      return acc;
    },
    {}
  );
  const environments = Object.entries(data.environments || {}).reduce(
    (acc, [key, environment]) => {
      acc[key] = {
        ...environment,
        uid: environment.uid
      };
      return acc;
    },
    {}
  );
  const requests = Object.entries(data.requests || {}).reduce(
    (acc, [key, request]) => {
      acc[key] = {
        ...request,
        uid: request.uid,
        servers: request.servers,
        selectedServerUid: request.selectedServerUid,
        examples: request.examples,
        selectedSecuritySchemeUids: request.selectedSecuritySchemeUids
      };
      return acc;
    },
    {}
  );
  const requestExamples = Object.entries(data.requestExamples || {}).reduce(
    (acc, [key, example]) => {
      const headers = example.parameters.headers;
      const hasAcceptHeader = headers.some((header) => header.key.toLowerCase() === "accept");
      if (!hasAcceptHeader) {
        headers.unshift({ key: "Accept", value: "*/*", enabled: true });
      }
      acc[key] = {
        ...example,
        uid: example.uid,
        requestUid: example.requestUid,
        parameters: {
          ...example.parameters,
          headers
        }
      };
      return acc;
    },
    {}
  );
  const securitySchemes = Object.entries(data.securitySchemes || {}).reduce(
    (acc, [key, securityScheme]) => {
      acc[key] = {
        ...securityScheme,
        uid: securityScheme.uid
      };
      return acc;
    },
    {}
  );
  const servers = Object.entries(data.servers || {}).reduce((acc, [key, server]) => {
    acc[key] = {
      ...server,
      uid: server.uid,
      variables: Object.entries(server.variables || {}).reduce((variablesAcc, [variableKey, variable]) => {
        variablesAcc[variableKey] = {
          default: variable.default ?? "",
          description: variable.description ?? "",
          ...variable.enum?.length && { enum: variable.enum }
        };
        return variablesAcc;
      }, {})
    };
    return acc;
  }, {});
  const tags = Object.entries(data.tags || {}).reduce((acc, [key, tag]) => {
    acc[key] = {
      ...tag,
      uid: tag.uid,
      children: tag.children
    };
    return acc;
  }, {});
  const workspaces = Object.entries(data.workspaces || {}).reduce(
    (acc, [key, workspace]) => {
      acc[key] = {
        ...workspace,
        uid: workspace.uid,
        collections: workspace.collections.map((uid) => uid),
        cookies: workspace.cookies.map((uid) => uid),
        selectedHttpClient: {
          targetKey: "shell",
          clientKey: "curl"
        }
      };
      return acc;
    },
    {}
  );
  return {
    ...data,
    collections,
    cookies,
    environments,
    requests,
    requestExamples,
    securitySchemes,
    servers,
    tags,
    workspaces
  };
};
export {
  migrate_v_2_5_0
};
//# sourceMappingURL=migration.js.map
