import { getExampleFromSchema } from "./get-example-from-schema.js";
function getParametersFromOperation(operation, where, requiredOnly = true) {
  const parameters = [...operation.pathParameters || [], ...operation.information?.parameters || []];
  const params = parameters.filter((parameter) => parameter.in === where).filter((parameter) => requiredOnly && parameter.required || !requiredOnly).map((parameter) => ({
    name: parameter.name,
    description: parameter.description ?? null,
    value: parameter.example ? parameter.example : parameter.schema ? getExampleFromSchema(parameter.schema, { mode: "write" }) : "",
    required: parameter.required ?? false,
    enabled: parameter.required ?? false
  }));
  return params.sort((a, b) => {
    if (a.required && !b.required) {
      return -1;
    }
    if (!a.required && b.required) {
      return 1;
    }
    return 0;
  });
}
export {
  getParametersFromOperation
};
//# sourceMappingURL=get-parameters-from-operation.js.map
