import type { OpenAPIV3_1 } from '@scalar/openapi-types';
import type { ApiReferenceConfiguration } from '@scalar/types/api-reference';
import { type SecurityScheme } from '@scalar/types/entities';
import type { UnknownObject } from '@scalar/types/utils';
import type { SelectedSecuritySchemeUids } from '../entities/shared/utility.js';
import { type Collection, type CollectionPayload } from '../entities/spec/collection.js';
import { type RequestExample } from '../entities/spec/request-examples.js';
import { type Request } from '../entities/spec/requests.js';
import { type Server } from '../entities/spec/server.js';
import { type Tag } from '../entities/spec/spec-objects.js';
/** Takes a string or object and parses it into an openapi spec compliant schema */
export declare const parseSchema: (originalDocument: string | UnknownObject | undefined, { shouldLoad, dereferencedDocument, }?: {
    shouldLoad?: boolean;
    dereferencedDocument?: OpenAPIV3_1.Document;
}) => Promise<{
    /**
     * Temporary fix for the parser returning an empty array
     * TODO: remove this once the parser is fixed
     */
    schema: OpenAPIV3_1.Document;
    errors: import("@scalar/openapi-parser").ErrorObject[];
}>;
/** Converts selected security requirements to uids */
export declare const getSelectedSecuritySchemeUids: (securityRequirements: (string | string[])[], preferredSecurityNames: (string | string[])[] | undefined, securitySchemeMap: Record<string, SecurityScheme["uid"]>) => SelectedSecuritySchemeUids;
/** Create a "uid" from a slug */
export declare const getSlugUid: (slug: string) => Collection["uid"];
export type ImportSpecToWorkspaceArgs = Pick<CollectionPayload, 'documentUrl' | 'watchMode'> & Pick<ApiReferenceConfiguration, 'authentication' | 'baseServerURL' | 'servers' | 'slug'> & {
    /** The dereferenced document */
    dereferencedDocument?: OpenAPIV3_1.Document;
    /** Sets the preferred security scheme on the collection instead of the requests */
    useCollectionSecurity?: boolean;
    /** Call the load step from the parser */
    shouldLoad?: boolean;
};
/**
 * Imports an OpenAPI document and converts it to workspace entities (Collection, Request, Server, etc.)
 *
 * The imported entities maintain a close mapping to the original OpenAPI specification to enable:
 * - Bi-directional translation between spec and workspace entities
 * - Preservation of specification details and structure
 * - Accurate representation of relationships between components
 *
 * Relationships between entities are maintained through unique identifiers (UIDs) which allow:
 * - Flexible organization at different levels (workspace, collection, request)
 * - Proper linking between related components
 * - Easy lookup and reference of dependent entities
 */
export declare function importSpecToWorkspace(content: string | UnknownObject | undefined, { 
/** If a dereferenced document is provided, we will skip the dereferencing step. */
dereferencedDocument, authentication, baseServerURL, documentUrl, servers: configuredServers, useCollectionSecurity, slug, shouldLoad, watchMode, }?: ImportSpecToWorkspaceArgs): Promise<{
    error: false;
    collection: Collection;
    requests: Request[];
    schema: OpenAPIV3_1.Document;
    examples: RequestExample[];
    servers: Server[];
    tags: Tag[];
    securitySchemes: SecurityScheme[];
} | {
    error: true;
    importWarnings: string[];
    collection: undefined;
}>;
/**
 * Retrieves a list of servers from an OpenAPI document and converts them to a list of Server entities.
 */
export declare function getServersFromOpenApiDocument(servers: OpenAPIV3_1.ServerObject[] | undefined, { baseServerURL }?: Pick<ApiReferenceConfiguration, 'baseServerURL'>): Server[];
//# sourceMappingURL=import-spec.d.ts.map