/** Date sorting for arrays */
export declare function timeSort<T>(a: T, b: T, key?: T extends object ? keyof T : never): number;
/** Sort alphanumerically */
export declare function alphaSort<T>(a: T, b: T, key?: T extends object ? keyof T : never): number;
/**
 * Immutably sorts a list by another list with O(n) time
 * Returns a sorted copy with any unsorted items at the end of list
 */
export declare function sortByOrder<T extends Record<K, string>, K extends keyof T>(arr: T[], order: string[], idKey: K): T[];
//# sourceMappingURL=sort.d.ts.map