type CallbackFunction = (...args: any[]) => any;
/**
 * Dependency-less debounce function with max wait
 * derived from @url https://dev.to/cantem/how-to-write-a-debounce-function-1bdf
 *
 * @param fn - any function to debounce
 * @param wait - time in ms to wait after function call to invoke function
 * @param {number} maxWait - time in ms to wait after function call to invoke function even if it's still being called
 */
export declare function debounce<T extends CallbackFunction>(fn: T, wait: number, { maxWait }?: {
    maxWait?: number;
}): (...args: any[]) => void;
export {};
//# sourceMappingURL=debounce.d.ts.map