/**
 * Return a hash map from an array object using a generated key
 *
 * Example:
 * ```
 * const mappedObj =
 *   objectFromArray([{ key: '1', name: 'one' }, { key: '2', name: 'two'}], (item) => item.key)
 *
 * const result = {
 *   '1': { key: '1', name: 'one' },
 *   '2': { key: '2', name: 'two' }
 * }
 * ```
 */
export declare function objectFromArray<T extends object>(data: T[], keyGenerator: (val: T) => string): Record<string, T>;
//# sourceMappingURL=object-from-array.d.ts.map