function debounce(fn, wait, { maxWait } = {}) {
  let timer = null;
  let maxTimer = null;
  return function(...args) {
    if (timer) {
      clearTimeout(timer);
    }
    timer = setTimeout(() => {
      maxTimer !== null ? clearTimeout(maxTimer) : null;
      maxTimer = null;
      fn.apply(this, args);
    }, wait);
    if (maxWait && !maxTimer) {
      maxTimer = setTimeout(() => {
        timer !== null ? clearTimeout(timer) : null;
        maxTimer = null;
        fn.apply(this, args);
      }, maxWait);
    }
  };
}
export {
  debounce
};
//# sourceMappingURL=debounce.js.map
