import { afterEach, beforeEach, describe, expect, it, vi } from "vitest";
import { debounce } from "./debounce.js";
describe("Functions are debounced", () => {
  beforeEach(() => {
    vi.useFakeTimers();
  });
  afterEach(() => {
    vi.restoreAllMocks();
  });
  it("Debounce function", () => {
    const func = vi.fn();
    const debouncedFunc = debounce(func, 1e3);
    debouncedFunc();
    expect(func).toHaveBeenCalledTimes(0);
    for (let i = 0; i < 10; i++) {
      vi.advanceTimersByTime(500);
      debouncedFunc();
    }
    expect(func).toHaveBeenCalledTimes(0);
    vi.advanceTimersByTime(1e3);
    expect(func).toHaveBeenCalledTimes(1);
  });
  it("Debounce function with max wait", () => {
    const func = vi.fn();
    const debouncedFunc = debounce(func, 1e3, { maxWait: 2e3 });
    debouncedFunc();
    expect(func).toHaveBeenCalledTimes(0);
    for (let i = 0; i < 10; i++) {
      vi.advanceTimersByTime(500);
      debouncedFunc();
    }
    expect(func).toHaveBeenCalledTimes(2);
  });
});
//# sourceMappingURL=debounce.test.js.map
