import Swagger20 from "../schemas/v2.0/schema.js";
import OpenApi30 from "../schemas/v3.0/schema.js";
import OpenApi31 from "../schemas/v3.1/schema.js";
const OpenApiSpecifications = {
  "2.0": Swagger20,
  "3.0": OpenApi30,
  "3.1": OpenApi31
};
const OpenApiVersions = Object.keys(OpenApiSpecifications);
const ERRORS = {
  EMPTY_OR_INVALID: "Can\u2019t find JSON, YAML or filename in data.",
  // URI_MUST_BE_STRING: 'uri parameter or $id attribute must be a string',
  OPENAPI_VERSION_NOT_SUPPORTED: "Can\u2019t find supported Swagger/OpenAPI version in the provided document, version must be a string.",
  INVALID_REFERENCE: "Can\u2019t resolve reference: %s",
  EXTERNAL_REFERENCE_NOT_FOUND: "Can\u2019t resolve external reference: %s",
  FILE_DOES_NOT_EXIST: "File does not exist: %s",
  NO_CONTENT: "No content found"
};
export {
  ERRORS,
  OpenApiSpecifications,
  OpenApiVersions
};
//# sourceMappingURL=index.js.map
