import BaseValidationError from "./base.js";
class DefaultValidationError extends BaseValidationError {
  constructor(...args) {
    super(...args);
    this.name = "DefaultValidationError";
    this.options.isSkipEndLocation = true;
  }
  getError() {
    const { keyword, message } = this.options;
    return {
      message: `${keyword} ${message}`,
      path: this.instancePath
    };
  }
}
export {
  DefaultValidationError as default
};
//# sourceMappingURL=default.js.map
