import { normalize } from "../../../utils/normalize.js";
import { isRemoteUrl } from "../../../utils/bundle/bundle.js";
import { createLimiter } from "../../../utils/bundle/create-limiter.js";
async function fetchUrl(url, limiter, config) {
  try {
    const domain = new URL(url).host;
    const headers = config?.headers?.find((a) => a.domains.find((d) => d === domain) !== void 0)?.headers;
    const result = await limiter(
      () => fetch(url, {
        headers
      })
    );
    if (result.ok) {
      const body = await result.text();
      return {
        ok: true,
        data: normalize(body)
      };
    }
    return {
      ok: false
    };
  } catch {
    return {
      ok: false
    };
  }
}
function fetchUrls(config) {
  const limiter = config?.limit ? createLimiter(config.limit) : (fn) => fn();
  return {
    validate: (value) => isRemoteUrl(value),
    exec: (value) => fetchUrl(value, limiter, config)
  };
}
export {
  fetchUrl,
  fetchUrls
};
//# sourceMappingURL=fetch-urls.js.map
