import { normalize } from "../../../utils/normalize.js";
import { isRemoteUrl } from "../../../utils/bundle/bundle.js";
const fs = typeof window === "undefined" ? await import("node:fs/promises") : void 0;
async function readFile(path) {
  if (fs === void 0) {
    throw "Can not use readFiles plugin outside of a node environment";
  }
  try {
    const fileContents = await fs.readFile(path, { encoding: "utf-8" });
    return {
      ok: true,
      data: normalize(fileContents)
    };
  } catch {
    return {
      ok: false
    };
  }
}
function readFiles() {
  return {
    validate: (value) => !isRemoteUrl(value),
    exec: (value) => readFile(value)
  };
}
export {
  readFile,
  readFiles
};
//# sourceMappingURL=read-files.js.map
