import { getEntrypoint } from "./get-entrypoint.js";
import { isFilesystem } from "./is-filesystem.js";
import { normalize } from "./normalize.js";
import { upgradeFromThreeToThreeOne } from "./upgrade-from-three-to-three-one.js";
import { upgradeFromTwoToThree } from "./upgrade-from-two-to-three.js";
const upgraders = [
  // Swagger 2.0 -> OpenAPI 3.0
  upgradeFromTwoToThree,
  // OpenAPI 3.0 -> OpenAPI 3.1
  upgradeFromThreeToThreeOne
];
function upgrade(value) {
  if (!value) {
    return {
      specification: null,
      version: "3.1"
    };
  }
  const result = upgraders.reduce(
    (currentSpecification, upgrader) => upgrader(currentSpecification),
    isFilesystem(value) ? getEntrypoint(value).specification : normalize(value)
  );
  return {
    specification: result,
    // TODO: Make dynamic
    version: "3.1"
  };
}
export {
  upgrade
};
//# sourceMappingURL=upgrade.js.map
