import { Validator } from "../lib/Validator/Validator.js";
import { makeFilesystem } from "./make-filesystem.js";
async function validate(value, options) {
  const filesystem = makeFilesystem(value);
  const validator = new Validator();
  const result = await validator.validate(filesystem, options);
  return {
    ...result,
    specification: validator.specification,
    version: validator.version
  };
}
export {
  validate
};
//# sourceMappingURL=validate.js.map
