function normalizeArray(parts, allowAboveRoot) {
  let up = 0;
  for (let i = parts.length - 1; i >= 0; i--) {
    const last = parts[i];
    if (last === ".") {
      parts.splice(i, 1);
    } else if (last === "..") {
      parts.splice(i, 1);
      up++;
    } else if (up) {
      parts.splice(i, 1);
      up--;
    }
  }
  if (allowAboveRoot) {
    for (; up--; up) {
      parts.unshift("..");
    }
  }
  return parts;
}
const splitPathRe = /^(\/?|)([\s\S]*?)((?:\.{1,2}|[^/]+?|)(\.[^./]*|))(?:[/]*)$/;
const splitPath = (filename) => splitPathRe.exec(filename).slice(1);
function resolve(...parameters) {
  let resolvedPath = "", resolvedAbsolute = false;
  for (let i = parameters.length - 1; i >= -1 && !resolvedAbsolute; i--) {
    const path = i >= 0 ? parameters[i] : "/";
    if (typeof path !== "string") {
      throw new TypeError("Arguments to path.resolve must be strings");
    }
    if (!path) {
      continue;
    }
    resolvedPath = path + "/" + resolvedPath;
    resolvedAbsolute = path.charAt(0) === "/";
  }
  resolvedPath = normalizeArray(
    filter(resolvedPath.split("/"), (p) => !!p),
    !resolvedAbsolute
  ).join("/");
  return (resolvedAbsolute ? "/" : "") + resolvedPath || ".";
}
function normalize(path) {
  const isPathAbsolute = isAbsolute(path), trailingSlash = substr(path, -1) === "/";
  path = normalizeArray(
    filter(path.split("/"), (p) => !!p),
    !isPathAbsolute
  ).join("/");
  if (!path && !isPathAbsolute) {
    path = ".";
  }
  if (path && trailingSlash) {
    path += "/";
  }
  return (isPathAbsolute ? "/" : "") + path;
}
function isAbsolute(path) {
  return path.charAt(0) === "/";
}
function join(...paths) {
  return normalize(
    filter(paths, (p, _index) => {
      if (typeof p !== "string") {
        throw new TypeError("Arguments to path.join must be strings");
      }
      return p;
    }).join("/")
  );
}
function relative(from, to) {
  from = resolve(from).substr(1);
  to = resolve(to).substr(1);
  function trim(arr) {
    let start = 0;
    for (; start < arr.length; start++) {
      if (arr[start] !== "") {
        break;
      }
    }
    let end = arr.length - 1;
    for (; end >= 0; end--) {
      if (arr[end] !== "") {
        break;
      }
    }
    if (start > end) {
      return [];
    }
    return arr.slice(start, end - start + 1);
  }
  const fromParts = trim(from.split("/"));
  const toParts = trim(to.split("/"));
  const length = Math.min(fromParts.length, toParts.length);
  let samePartsLength = length;
  for (let i = 0; i < length; i++) {
    if (fromParts[i] !== toParts[i]) {
      samePartsLength = i;
      break;
    }
  }
  let outputParts = [];
  for (let i = samePartsLength; i < fromParts.length; i++) {
    outputParts.push("..");
  }
  outputParts = outputParts.concat(toParts.slice(samePartsLength));
  return outputParts.join("/");
}
const sep = "/";
const delimiter = ":";
function dirname(path) {
  const result = splitPath(path), root = result[0];
  let dir = result[1];
  if (!root && !dir) {
    return ".";
  }
  if (dir) {
    dir = dir.substr(0, dir.length - 1);
  }
  return root + dir;
}
function basename(path, ext) {
  let f = splitPath(path)[2];
  if (ext && f.substr(-1 * ext.length) === ext) {
    f = f.substr(0, f.length - ext.length);
  }
  return f;
}
function extname(path) {
  return splitPath(path)[3];
}
var path_default = {
  extname,
  basename,
  dirname,
  sep,
  delimiter,
  relative,
  join,
  isAbsolute,
  normalize,
  resolve
};
function filter(xs, f) {
  if (xs.filter) {
    return xs.filter(f);
  }
  const res = [];
  for (let i = 0; i < xs.length; i++) {
    if (f(xs[i], i, xs)) {
      res.push(xs[i]);
    }
  }
  return res;
}
const substr = "ab".substr(-1) === "b" ? (str, start, len) => str.substr(start, len) : (str, start, len) => {
  if (start < 0) {
    start = str.length + start;
  }
  return str.substr(start, len);
};
export {
  basename,
  path_default as default,
  delimiter,
  dirname,
  extname,
  isAbsolute,
  join,
  normalize,
  relative,
  resolve,
  sep
};
//# sourceMappingURL=path.js.map
