import { traverse } from "./traverse.js";
const SCHEMA_SEGMENTS = /* @__PURE__ */ new Set([
  "properties",
  "items",
  "allOf",
  "anyOf",
  "oneOf",
  "not",
  "additionalProperties",
  "schema"
]);
function isSchemaPath(path) {
  if (path.some((segment) => SCHEMA_SEGMENTS.has(segment))) {
    return true;
  }
  if (path.some((segment) => segment.endsWith("Schema"))) {
    return true;
  }
  if (path.length >= 2 && path[0] === "components" && path[1] === "schemas") {
    return true;
  }
  return false;
}
function upgradeFromThreeToThreeOne(originalContent) {
  let content = originalContent;
  if (content === null || typeof content.openapi !== "string" || !content.openapi.startsWith("3.0")) {
    return content;
  }
  content.openapi = "3.1.1";
  content = traverse(content, applyChangesToDocument);
  return content;
}
const applyChangesToDocument = (schema, path) => {
  if (schema.type !== "undefined" && schema.nullable === true) {
    schema.type = [schema.type, "null"];
    delete schema.nullable;
  }
  if (schema.exclusiveMinimum === true) {
    schema.exclusiveMinimum = schema.minimum;
    delete schema.minimum;
  } else if (schema.exclusiveMinimum === false) {
    delete schema.exclusiveMinimum;
  }
  if (schema.exclusiveMaximum === true) {
    schema.exclusiveMaximum = schema.maximum;
    delete schema.maximum;
  } else if (schema.exclusiveMaximum === false) {
    delete schema.exclusiveMaximum;
  }
  if (schema.example !== void 0) {
    if (isSchemaPath(path)) {
      schema.examples = [schema.example];
    } else {
      schema.examples = {
        default: {
          value: schema.example
        }
      };
    }
    delete schema.example;
  }
  if (schema.type === "object" && schema.properties !== void 0) {
    const parentPath = path.slice(0, -1);
    const isMultipart = parentPath.some((segment, index) => {
      return segment === "content" && path[index + 1] === "multipart/form-data";
    });
    if (isMultipart) {
      for (const value of Object.values(schema.properties)) {
        if (typeof value === "object" && value !== null && "type" in value && "format" in value && value.type === "string" && value.format === "binary") {
          ;
          value.contentMediaType = "application/octet-stream";
          delete value.format;
        }
      }
    }
  }
  if (path.includes("content") && path.includes("application/octet-stream")) {
    return {};
  }
  if (schema.type === "string") {
    if (schema.format === "binary") {
      return {
        type: "string",
        contentMediaType: "application/octet-stream"
      };
    }
    if (schema.format === "base64") {
      return {
        type: "string",
        contentEncoding: "base64"
      };
    }
    if (schema.format === "byte") {
      const parentPath = path.slice(0, -1);
      const contentMediaType = parentPath.find((_, index) => path[index - 1] === "content");
      return {
        type: "string",
        contentEncoding: "base64",
        contentMediaType
      };
    }
  }
  return schema;
};
export {
  isSchemaPath,
  upgradeFromThreeToThreeOne
};
//# sourceMappingURL=upgrade-from-three-to-three-one.js.map
