import type { OpenAPIV3_1 } from '@scalar/openapi-types';
/**
 * Infers the schema of an OpenAPI object based on an example value.
 * This function recursively analyzes the structure of the example value
 * and returns a corresponding OpenAPI schema object.
 */
export declare function inferSchemaFromExample(example: any): OpenAPIV3_1.SchemaObject;
/**
 * Infers the schema type of a value based on its type.
 * This function determines the OpenAPI schema type of a value
 * by checking its JavaScript type and attempting to parse it
 * as a number or boolean if it's a string.
 */
export declare function inferSchemaType(value: any): OpenAPIV3_1.SchemaObject;
//# sourceMappingURL=schemaHelpers.d.ts.map