/**
 * Extracts the domain (including protocol and port if present) from a given URL.
 */
export declare function getDomainFromUrl(url: string): string;
/**
 * Extracts the path from a given URL, removing any Postman variables.
 */
export declare function extractPathFromUrl(url: string | undefined): string;
/**
 * Normalizes a path by converting colon-style parameters to curly brace style
 * e.g., '/users/:id' becomes '/users/{id}'
 */
export declare const normalizePath: (path: string) => string;
/**
 * Extracts parameter names from a path string.
 * Handles double curly braces {{param}}, single curly braces {param}, and colon format :param.
 */
export declare function extractPathParameterNames(path: string): string[];
//# sourceMappingURL=urlHelpers.d.ts.map