import type { OpenAPIV3_1 } from '@scalar/openapi-types';
import type { Auth } from '../types.js';
/**
 * Processes authentication information from a Postman collection and updates
 * the OpenAPI document with the corresponding security schemes and requirements.
 * Supports API key, basic auth, bearer token, OAuth2, and no authentication types.
 */
export declare function processAuth(auth: Auth): {
    securitySchemes: Record<string, OpenAPIV3_1.SecuritySchemeObject>;
    security: OpenAPIV3_1.SecurityRequirementObject[];
};
//# sourceMappingURL=authHelpers.d.ts.map