import type { OpenAPIV3_1 } from '@scalar/openapi-types';
import type { PostmanCollection } from '../types.js';
type InfoResult = {
    license?: OpenAPIV3_1.LicenseObject;
    contact?: OpenAPIV3_1.ContactObject;
};
/**
 * Processes the license and contact information from a Postman Collection.
 * This function checks for license and contact related variables in the collection
 * and creates corresponding OpenAPI License and Contact Objects if the information is present.
 */
export declare function processLicenseAndContact(collection: PostmanCollection): InfoResult;
export {};
//# sourceMappingURL=licenseContactHelper.d.ts.map