import type { OpenAPIV3_1 } from '@scalar/openapi-types';
import type { Request } from '../types.js';
/**
 * Extracts parameters from a Postman request and converts them to OpenAPI parameter objects.
 * Processes query, path, and header parameters from the request URL and headers.
 */
export declare function extractParameters(request: Request): OpenAPIV3_1.ParameterObject[];
/**
 * Creates an OpenAPI parameter object from a Postman parameter.
 */
export declare function createParameterObject(param: any, paramIn: 'query' | 'path' | 'header'): OpenAPIV3_1.ParameterObject;
//# sourceMappingURL=parameterHelpers.d.ts.map