import type { OpenAPIV3_1 } from '@scalar/openapi-types';
import type { Item, ItemGroup } from '../types.js';
/**
 * Processes a Postman collection item or item group and returns
 * the corresponding OpenAPI paths and components.
 * Handles nested item groups, extracts request details, and generates corresponding
 * OpenAPI path items and operations.
 */
export declare function processItem(item: Item | ItemGroup, parentTags?: string[], parentPath?: string): {
    paths: OpenAPIV3_1.PathsObject;
    components: OpenAPIV3_1.ComponentsObject;
};
//# sourceMappingURL=itemHelpers.d.ts.map