import { cLibcurl } from './plugins/c/libcurl/libcurl.js';
import { javaNethttp } from './plugins/java/nethttp/nethttp.js';
import { javaOkhttp } from './plugins/java/okhttp/okhttp.js';
import { javaUnirest } from './plugins/java/unirest/unirest.js';
import { csharpHttpclient } from './plugins/csharp/httpclient/httpclient.js';
import { csharpRestsharp } from './plugins/csharp/restsharp/restsharp.js';
import { clojureCljhttp } from './plugins/clojure/clj_http/clj_http.js';
import { dartHttp } from './plugins/dart/http/http.js';
import { goNative } from './plugins/go/native/native.js';
import { httpHttp11 } from './plugins/http/http11/http11.js';
import { javaAsynchttp } from './plugins/java/asynchttp/asynchttp.js';
import { jsFetch } from './plugins/js/fetch/fetch.js';
import { jsAxios } from './plugins/js/axios/axios.js';
import { jsOfetch } from './plugins/js/ofetch/ofetch.js';
import { jsJquery } from './plugins/js/jquery/jquery.js';
import { jsXhr } from './plugins/js/xhr/xhr.js';
import { kotlinOkhttp } from './plugins/kotlin/okhttp/okhttp.js';
import { nodeFetch } from './plugins/node/fetch/fetch.js';
import { nodeAxios } from './plugins/node/axios/axios.js';
import { nodeOfetch } from './plugins/node/ofetch/ofetch.js';
import { nodeUndici } from './plugins/node/undici/undici.js';
import { objcNsurlsession } from './plugins/objc/nsurlsession/nsurlsession.js';
import { ocamlCohttp } from './plugins/ocaml/cohttp/cohttp.js';
import { phpCurl } from './plugins/php/curl/curl.js';
import { phpGuzzle } from './plugins/php/guzzle/guzzle.js';
import { powershellWebrequest } from './plugins/powershell/webrequest/webrequest.js';
import { powershellRestmethod } from './plugins/powershell/restmethod/restmethod.js';
import { pythonPython3 } from './plugins/python/python3/python3.js';
import { pythonRequests } from './plugins/python/requests/requests.js';
import { rHttr } from './plugins/r/httr/httr.js';
import { rubyNative } from './plugins/ruby/native/native.js';
import { shellCurl } from './plugins/shell/curl/curl.js';
import { shellWget } from './plugins/shell/wget/wget.js';
import { shellHttpie } from './plugins/shell/httpie/httpie.js';
import { swiftNsurlsession } from './plugins/swift/nsurlsession/nsurlsession.js';

/**
 * All available clients
 */
const clients = [
    {
        key: 'c',
        title: 'C',
        default: 'libcurl',
        clients: [cLibcurl],
    },
    {
        key: 'csharp',
        title: 'C#',
        default: 'restsharp',
        clients: [csharpHttpclient, csharpRestsharp],
    },
    {
        key: 'clojure',
        title: 'Clojure',
        default: 'clj_http',
        clients: [clojureCljhttp],
    },
    {
        key: 'dart',
        title: 'Dart',
        default: 'http',
        clients: [dartHttp],
    },
    {
        key: 'go',
        title: 'Go',
        default: 'native',
        clients: [goNative],
    },
    {
        key: 'http',
        title: 'HTTP',
        default: 'http1.1',
        clients: [httpHttp11],
    },
    {
        key: 'java',
        title: 'Java',
        default: 'unirest',
        clients: [javaAsynchttp, javaNethttp, javaOkhttp, javaUnirest],
    },
    {
        key: 'js',
        title: 'JavaScript',
        default: 'fetch',
        clients: [jsFetch, jsAxios, jsOfetch, jsJquery, jsXhr],
    },
    {
        key: 'kotlin',
        title: 'Kotlin',
        default: 'okhttp',
        clients: [kotlinOkhttp],
    },
    {
        key: 'node',
        title: 'Node.js',
        default: 'fetch',
        clients: [nodeFetch, nodeAxios, nodeOfetch, nodeUndici],
    },
    {
        key: 'objc',
        title: 'Objective-C',
        default: 'nsurlsession',
        clients: [objcNsurlsession],
    },
    {
        key: 'ocaml',
        title: 'OCaml',
        default: 'cohttp',
        clients: [ocamlCohttp],
    },
    {
        key: 'php',
        title: 'PHP',
        default: 'curl',
        clients: [phpCurl, phpGuzzle],
    },
    {
        key: 'powershell',
        title: 'Powershell',
        default: 'webrequest',
        clients: [powershellWebrequest, powershellRestmethod],
    },
    {
        key: 'python',
        title: 'Python',
        default: 'python3',
        clients: [pythonPython3, pythonRequests],
    },
    {
        key: 'r',
        title: 'R',
        default: 'httr',
        clients: [rHttr],
    },
    {
        key: 'ruby',
        title: 'Ruby',
        default: 'native',
        clients: [rubyNative],
    },
    {
        key: 'shell',
        title: 'Shell',
        default: 'curl',
        clients: [shellCurl, shellWget, shellHttpie],
    },
    {
        key: 'swift',
        title: 'Swift',
        default: 'nsurlsession',
        clients: [swiftNsurlsession],
    },
];

export { clients };
