import { cLibcurl } from "./plugins/c/libcurl/libcurl.js";
import { clojureCljhttp } from "./plugins/clojure/clj_http/index.js";
import { csharpHttpclient } from "./plugins/csharp/httpclient/index.js";
import { csharpRestsharp } from "./plugins/csharp/restsharp/index.js";
import { dartHttp } from "./plugins/dart/http/index.js";
import { goNative } from "./plugins/go/native/index.js";
import { httpHttp11 } from "./plugins/http/http11/index.js";
import { javaAsynchttp } from "./plugins/java/asynchttp/index.js";
import { javaNethttp } from "./plugins/java/nethttp/nethttp.js";
import { javaOkhttp } from "./plugins/java/okhttp/okhttp.js";
import { javaUnirest } from "./plugins/java/unirest/unirest.js";
import { jsAxios } from "./plugins/js/axios/index.js";
import { jsFetch } from "./plugins/js/fetch/index.js";
import { jsJquery } from "./plugins/js/jquery/index.js";
import { jsOfetch } from "./plugins/js/ofetch/index.js";
import { jsXhr } from "./plugins/js/xhr/index.js";
import { kotlinOkhttp } from "./plugins/kotlin/okhttp/index.js";
import { nodeAxios } from "./plugins/node/axios/index.js";
import { nodeFetch } from "./plugins/node/fetch/index.js";
import { nodeOfetch } from "./plugins/node/ofetch/index.js";
import { nodeUndici } from "./plugins/node/undici/index.js";
import { objcNsurlsession } from "./plugins/objc/nsurlsession/index.js";
import { ocamlCohttp } from "./plugins/ocaml/cohttp/index.js";
import { phpCurl } from "./plugins/php/curl/index.js";
import { phpGuzzle } from "./plugins/php/guzzle/index.js";
import { powershellRestmethod } from "./plugins/powershell/restmethod/index.js";
import { powershellWebrequest } from "./plugins/powershell/webrequest/index.js";
import { pythonPython3 } from "./plugins/python/python3/index.js";
import { pythonRequests } from "./plugins/python/requests/index.js";
import { rHttr } from "./plugins/r/httr/index.js";
import { rubyNative } from "./plugins/ruby/native/index.js";
import { shellCurl } from "./plugins/shell/curl/index.js";
import { shellHttpie } from "./plugins/shell/httpie/index.js";
import { shellWget } from "./plugins/shell/wget/index.js";
import { swiftNsurlsession } from "./plugins/swift/nsurlsession/index.js";
const clients = [
  {
    key: "c",
    title: "C",
    default: "libcurl",
    clients: [cLibcurl]
  },
  {
    key: "csharp",
    title: "C#",
    default: "restsharp",
    clients: [csharpHttpclient, csharpRestsharp]
  },
  {
    key: "clojure",
    title: "Clojure",
    default: "clj_http",
    clients: [clojureCljhttp]
  },
  {
    key: "dart",
    title: "Dart",
    default: "http",
    clients: [dartHttp]
  },
  {
    key: "go",
    title: "Go",
    default: "native",
    clients: [goNative]
  },
  {
    key: "http",
    title: "HTTP",
    default: "http1.1",
    clients: [httpHttp11]
  },
  {
    key: "java",
    title: "Java",
    default: "unirest",
    clients: [javaAsynchttp, javaNethttp, javaOkhttp, javaUnirest]
  },
  {
    key: "js",
    title: "JavaScript",
    default: "fetch",
    clients: [jsFetch, jsAxios, jsOfetch, jsJquery, jsXhr]
  },
  {
    key: "kotlin",
    title: "Kotlin",
    default: "okhttp",
    clients: [kotlinOkhttp]
  },
  {
    key: "node",
    title: "Node.js",
    default: "fetch",
    clients: [nodeFetch, nodeAxios, nodeOfetch, nodeUndici]
  },
  {
    key: "objc",
    title: "Objective-C",
    default: "nsurlsession",
    clients: [objcNsurlsession]
  },
  {
    key: "ocaml",
    title: "OCaml",
    default: "cohttp",
    clients: [ocamlCohttp]
  },
  {
    key: "php",
    title: "PHP",
    default: "curl",
    clients: [phpCurl, phpGuzzle]
  },
  {
    key: "powershell",
    title: "Powershell",
    default: "webrequest",
    clients: [powershellWebrequest, powershellRestmethod]
  },
  {
    key: "python",
    title: "Python",
    default: "python3",
    clients: [pythonPython3, pythonRequests]
  },
  {
    key: "r",
    title: "R",
    default: "httr",
    clients: [rHttr]
  },
  {
    key: "ruby",
    title: "Ruby",
    default: "native",
    clients: [rubyNative]
  },
  {
    key: "shell",
    title: "Shell",
    default: "curl",
    clients: [shellCurl, shellWget, shellHttpie]
  },
  {
    key: "swift",
    title: "Swift",
    default: "nsurlsession",
    clients: [swiftNsurlsession]
  }
];
export {
  clients
};
//# sourceMappingURL=clients.js.map
