function escapeString(rawValue, options = {}) {
  const { delimiter = '"', escapeChar = "\\", escapeNewlines = true } = options;
  const stringValue = rawValue.toString();
  return [...stringValue].map((c) => {
    if (c === "\b") {
      return `${escapeChar}b`;
    }
    if (c === "	") {
      return `${escapeChar}t`;
    }
    if (c === "\n") {
      if (escapeNewlines) {
        return `${escapeChar}n`;
      }
      return c;
    }
    if (c === "\f") {
      return `${escapeChar}f`;
    }
    if (c === "\r") {
      if (escapeNewlines) {
        return `${escapeChar}r`;
      }
      return c;
    }
    if (c === escapeChar) {
      return escapeChar + escapeChar;
    }
    if (c === delimiter) {
      return escapeChar + delimiter;
    }
    if (c < " " || c > "~") {
      return JSON.stringify(c).slice(1, -1);
    }
    return c;
  }).join("");
}
const escapeForSingleQuotes = (value) => escapeString(value, { delimiter: "'" });
const escapeForDoubleQuotes = (value) => escapeString(value, { delimiter: '"' });
export {
  escapeForDoubleQuotes,
  escapeForSingleQuotes,
  escapeString
};
//# sourceMappingURL=escape.js.map
