const getHeaderName = (headers, name) => Object.keys(headers).find(
  (header) => header.toLowerCase() === name.toLowerCase()
);
const getHeader = (headers, name) => {
  const headerName = getHeaderName(headers, name);
  if (!headerName) {
    return void 0;
  }
  return headers[headerName];
};
const hasHeader = (headers, name) => Boolean(getHeaderName(headers, name));
const mimeTypeJson = [
  "application/json",
  "application/x-json",
  "text/json",
  "text/x-json",
  "+json"
];
const isMimeTypeJSON = (mimeType) => mimeTypeJson.some((type) => mimeType.includes(type));
export {
  getHeader,
  getHeaderName,
  hasHeader,
  isMimeTypeJSON
};
//# sourceMappingURL=headers.js.map
