const reducer = (accumulator, pair) => {
  if (pair.value === void 0) {
    return accumulator;
  }
  const currentValue = accumulator[pair.name];
  if (currentValue === void 0) {
    accumulator[pair.name] = pair.value;
    return accumulator;
  }
  if (Array.isArray(currentValue)) {
    currentValue.push(pair.value);
    return accumulator;
  }
  accumulator[pair.name] = [currentValue, pair.value];
  return accumulator;
};
export {
  reducer
};
//# sourceMappingURL=reducer.js.map
