const quote = (value = "") => {
  const safe = /^[a-z0-9-_/.@%^=:]+$/i;
  const isShellSafe = safe.test(value);
  if (isShellSafe) {
    return value;
  }
  return `'${value.replace(/'/g, "'\\''")}'`;
};
const escape = (value) => value.replace(/\r/g, "\\r").replace(/\n/g, "\\n");
export {
  escape,
  quote
};
//# sourceMappingURL=shell.js.map
