const nsDeclaration = (nsClass, name, parameters, indent) => {
  const opening = `${nsClass} *${name} = `;
  const literal = literalRepresentation(
    parameters,
    indent ? opening.length : void 0
  );
  return `${opening}${literal};`;
};
const literalRepresentation = (value, indentation) => {
  const join = indentation === void 0 ? ", " : `,
   ${" ".repeat(indentation)}`;
  switch (Object.prototype.toString.call(value)) {
    case "[object Number]":
      return `@${value}`;
    case "[object Array]": {
      const valuesRepresentation = value.map(
        (value2) => literalRepresentation(value2)
      );
      return `@[ ${valuesRepresentation.join(join)} ]`;
    }
    case "[object Object]": {
      const keyValuePairs = [];
      for (const key in value) {
        keyValuePairs.push(`@"${key}": ${literalRepresentation(value[key])}`);
      }
      return `@{ ${keyValuePairs.join(join)} }`;
    }
    case "[object Boolean]":
      return value ? "@YES" : "@NO";
    default:
      if (value === null || value === void 0) {
        return "";
      }
      return `@"${value.toString().replace(/"/g, '\\"')}"`;
  }
};
export {
  literalRepresentation,
  nsDeclaration
};
//# sourceMappingURL=helpers.js.map
