import { escapeString } from "../../helpers/escape.js";
const convertType = (obj, indent, lastIndent) => {
  lastIndent = lastIndent || "";
  indent = indent || "";
  switch (Object.prototype.toString.call(obj)) {
    case "[object Null]":
      return "null";
    case "[object Undefined]":
      return "null";
    case "[object String]":
      return `'${escapeString(obj, { delimiter: "'", escapeNewlines: false })}'`;
    case "[object Number]":
      return obj.toString();
    case "[object Array]": {
      const contents = obj.map((item) => convertType(item, `${indent}${indent}`, indent)).join(`,
${indent}`);
      return `[
${indent}${contents}
${lastIndent}]`;
    }
    case "[object Object]": {
      const result = [];
      for (const i in obj) {
        if (Object.prototype.hasOwnProperty.call(obj, i)) {
          result.push(
            `${convertType(i, indent)} => ${convertType(obj[i], `${indent}${indent}`, indent)}`
          );
        }
      }
      return `[
${indent}${result.join(`,
${indent}`)}
${lastIndent}]`;
    }
    default:
      return "null";
  }
};
const supportedMethods = [
  "ACL",
  "BASELINE_CONTROL",
  "CHECKIN",
  "CHECKOUT",
  "CONNECT",
  "COPY",
  "DELETE",
  "GET",
  "HEAD",
  "LABEL",
  "LOCK",
  "MERGE",
  "MKACTIVITY",
  "MKCOL",
  "MKWORKSPACE",
  "MOVE",
  "OPTIONS",
  "POST",
  "PROPFIND",
  "PROPPATCH",
  "PUT",
  "REPORT",
  "TRACE",
  "UNCHECKOUT",
  "UNLOCK",
  "UPDATE",
  "VERSION_CONTROL"
];
export {
  convertType,
  supportedMethods
};
//# sourceMappingURL=helpers.js.map
