function concatValues(concatType, values, pretty, indentation, indentLevel) {
  const currentIndent = indentation.repeat(indentLevel);
  const closingBraceIndent = indentation.repeat(indentLevel - 1);
  const join = pretty ? `,
${currentIndent}` : ", ";
  const openingBrace = concatType === "object" ? "{" : "[";
  const closingBrace = concatType === "object" ? "}" : "]";
  if (pretty) {
    return `${openingBrace}
${currentIndent}${values.join(join)}
${closingBraceIndent}${closingBrace}`;
  }
  if (concatType === "object" && values.length > 0) {
    return `${openingBrace} ${values.join(join)} ${closingBrace}`;
  }
  return `${openingBrace}${values.join(join)}${closingBrace}`;
}
const literalRepresentation = (value, opts, indentLevel) => {
  indentLevel = indentLevel === void 0 ? 1 : indentLevel + 1;
  switch (Object.prototype.toString.call(value)) {
    case "[object Number]":
      return value;
    case "[object Array]": {
      let pretty = false;
      const valuesRepresentation = value.map((v) => {
        if (Object.prototype.toString.call(v) === "[object Object]") {
          pretty = Object.keys(v).length > 1;
        }
        return literalRepresentation(v, opts, indentLevel);
      });
      return concatValues(
        "array",
        valuesRepresentation,
        pretty,
        opts.indent,
        indentLevel
      );
    }
    case "[object Object]": {
      const keyValuePairs = [];
      for (const key in value) {
        keyValuePairs.push(
          `"${key}": ${literalRepresentation(value[key], opts, indentLevel)}`
        );
      }
      return concatValues(
        "object",
        keyValuePairs,
        opts.pretty && keyValuePairs.length > 1,
        opts.indent,
        indentLevel
      );
    }
    case "[object Null]":
      return "None";
    case "[object Boolean]":
      return value ? "True" : "False";
    default:
      if (value === null || value === void 0) {
        return "";
      }
      return `"${value.toString().replace(/"/g, '\\"')}"`;
  }
};
export {
  literalRepresentation
};
//# sourceMappingURL=helpers.js.map
