const dartHttp = {
  target: "dart",
  client: "http",
  title: "Http",
  generate(request, options) {
    const normalizedRequest = {
      method: "GET",
      ...request
    };
    normalizedRequest.method = normalizedRequest.method.toUpperCase();
    let code = `import 'package:http/http.dart' as http;

void main() async {
`;
    let cookieHeader = "";
    let cookieString = "";
    if (normalizedRequest.cookies && normalizedRequest.cookies.length > 0) {
      cookieString = normalizedRequest.cookies.map((cookie) => `${encodeURIComponent(cookie.name)}=${encodeURIComponent(cookie.value)}`).join("; ");
      cookieHeader = `  "Cookie": "${cookieString}",
`;
    }
    const headers = normalizedRequest.headers?.reduce(
      (acc, header) => {
        if (header.value && !/[; ]/.test(header.name)) {
          acc[header.name] = header.value;
        }
        return acc;
      },
      {}
    ) || {};
    if (options?.auth) {
      const { username, password } = options.auth;
      if (username && password) {
        const credentials = `${username}:${password}`;
        headers["Authorization"] = `'Basic ' + base64Encode(utf8.encode('${credentials}'))`;
      }
    }
    if (cookieHeader) {
      headers["Cookie"] = cookieString;
    }
    if (Object.keys(headers).length > 0) {
      code += "  final headers = <String,String>{\n";
      for (const [key, value] of Object.entries(headers)) {
        if (value.includes("utf8.encode")) {
          code += `    '${key}': ${value},
`;
        } else {
          code += `    '${key}': '${value}',
`;
        }
      }
      code += "  };\n\n";
    }
    const queryString = normalizedRequest.queryString?.length ? "?" + normalizedRequest.queryString.map((param) => `${encodeURIComponent(param.name)}=${encodeURIComponent(param.value)}`).join("&") : "";
    const url = `${normalizedRequest.url}${queryString}`;
    let body = "";
    if (normalizedRequest.postData) {
      if (normalizedRequest.postData.mimeType === "application/json") {
        body = `  final body = r'${normalizedRequest.postData.text}';

`;
      } else if (normalizedRequest.postData.mimeType === "application/x-www-form-urlencoded") {
        body = `  final body = '${normalizedRequest.postData.params?.map((param) => `${encodeURIComponent(param.name)}=${encodeURIComponent(param.value ?? "")}`).join("&") || ""}';

`;
      } else if (normalizedRequest.postData.mimeType === "multipart/form-data") {
        body = "  final body = <String,String>{\n";
        for (const param of normalizedRequest.postData.params || []) {
          const value = param.value || "";
          const fileName = param.fileName || "";
          body += `    '${param.name}': '${fileName || value}',
`;
        }
        body += "  };\n\n";
      } else if (normalizedRequest.postData.mimeType === "application/octet-stream") {
        body = `  final body = '${normalizedRequest.postData.text}';

`;
      }
    }
    if (body) {
      code += body;
    }
    const method = normalizedRequest.method.toLowerCase();
    const headersPart = Object.keys(headers).length > 0 ? ", headers: headers" : "";
    const bodyPart = body ? ", body: body" : "";
    code += `  final response = await http.${method}(Uri.parse('${url}')${headersPart}${bodyPart});
`;
    code += "  print(response.body);\n";
    code += "}";
    return code;
  }
};
export {
  dartHttp
};
//# sourceMappingURL=http.js.map
