const httpHttp11 = {
  target: "http",
  client: "http1.1",
  title: "HTTP/1.1",
  generate(request) {
    const normalizedRequest = {
      method: "GET",
      headers: [],
      queryString: [],
      ...request
    };
    normalizedRequest.method = normalizedRequest.method.toUpperCase();
    let url;
    let path;
    try {
      url = new URL(normalizedRequest.url || "http://");
      path = url.pathname + (url.search || "");
    } catch (_error) {
      path = normalizedRequest.url || "/";
    }
    const hostname = url?.hostname || "UNKNOWN_HOSTNAME";
    let requestString = `${normalizedRequest.method} ${path} HTTP/1.1\r
`;
    if (normalizedRequest.queryString.length) {
      const queryString = normalizedRequest.queryString.map((param) => `${encodeURIComponent(param.name)}=${encodeURIComponent(param.value)}`).join("&");
      requestString = `${normalizedRequest.method} ${path}?${queryString} HTTP/1.1\r
`;
    }
    const headers = /* @__PURE__ */ new Map();
    headers.set("Host", hostname);
    normalizedRequest.headers.forEach((header) => {
      if (headers.has(header.name)) {
        headers.set(header.name, `${headers.get(header.name)}, ${header.value}`);
      } else {
        headers.set(header.name, header.value);
      }
    });
    if (normalizedRequest.queryString.length) {
      const queryString = normalizedRequest.queryString.map((param) => `${encodeURIComponent(param.name)}=${encodeURIComponent(param.value)}`).join("&");
      requestString = `${normalizedRequest.method} ${path}?${queryString} HTTP/1.1\r
`;
    }
    let body = "";
    if (normalizedRequest.postData) {
      if (normalizedRequest.postData.mimeType === "application/json" && normalizedRequest.postData.text) {
        headers.set("Content-Type", "application/json");
        body = normalizedRequest.postData.text;
      } else if (normalizedRequest.postData.mimeType === "application/octet-stream" && normalizedRequest.postData.text) {
        headers.set("Content-Type", "application/octet-stream");
        body = normalizedRequest.postData.text;
      } else if (normalizedRequest.postData.mimeType === "application/x-www-form-urlencoded" && normalizedRequest.postData.params) {
        const formData = normalizedRequest.postData.params.map((param) => `${encodeURIComponent(param.name)}=${encodeURIComponent(param.value ?? "")}`).join("&");
        headers.set("Content-Type", "application/x-www-form-urlencoded");
        body = formData;
      } else if (normalizedRequest.postData.mimeType === "multipart/form-data" && normalizedRequest.postData.params) {
        const boundary = "----WebKitFormBoundary7MA4YWxkTrZu0gW";
        headers.set("Content-Type", `multipart/form-data; boundary=${boundary}`);
        body = normalizedRequest.postData.params.map((param) => {
          if (param.fileName) {
            return `--${boundary}\r
Content-Disposition: form-data; name="${param.name}"; filename="${param.fileName}"\r
\r
`;
          }
          return `--${boundary}\r
Content-Disposition: form-data; name="${param.name}"\r
\r
${param.value}\r
`;
        }).join("") + `--${boundary}--\r
`;
      }
    }
    headers.forEach((value, name) => {
      requestString += `${name}: ${value}\r
`;
    });
    requestString += `\r
${body}`;
    return requestString;
  }
};
export {
  httpHttp11
};
//# sourceMappingURL=http11.js.map
