import { createSearchParams } from "../../../utils/create-search-params.js";
import { objectToString, Unquoted } from "../../../utils/objectToString.js";
const nodeFetch = {
  target: "node",
  client: "fetch",
  title: "Fetch",
  generate(request) {
    const normalizedRequest = {
      method: "GET",
      ...request
    };
    let prefix = "";
    normalizedRequest.method = normalizedRequest.method.toUpperCase();
    const options = {
      method: normalizedRequest.method === "GET" ? void 0 : normalizedRequest.method
    };
    const searchParams = createSearchParams(normalizedRequest.queryString);
    const queryString = searchParams.size ? `?${searchParams.toString()}` : "";
    if (normalizedRequest.headers?.length) {
      options.headers = {};
      normalizedRequest.headers.forEach((header) => {
        options.headers[header.name] = header.value;
      });
    }
    if (normalizedRequest.cookies?.length) {
      options.headers = options.headers || {};
      normalizedRequest.cookies.forEach((cookie) => {
        options.headers["Set-Cookie"] = options.headers["Set-Cookie"] ? `${options.headers["Set-Cookie"]}; ${cookie.name}=${cookie.value}` : `${cookie.name}=${cookie.value}`;
      });
    }
    Object.keys(options).forEach((key) => {
      if (options[key] === void 0) {
        delete options[key];
      }
    });
    if (normalizedRequest.postData) {
      const { mimeType, text, params } = normalizedRequest.postData;
      let hasFsImport = false;
      if (mimeType === "application/json" && text) {
        try {
          options.body = new Unquoted(`JSON.stringify(${objectToString(JSON.parse(text))})`);
        } catch (e) {
          options.body = text;
        }
      } else if (mimeType === "multipart/form-data" && params) {
        prefix = "const formData = new FormData()\n";
        params.forEach((param) => {
          if (param.fileName !== void 0) {
            if (!hasFsImport) {
              prefix = `import fs from 'node:fs'

${prefix}`;
              hasFsImport = true;
            }
            prefix += `formData.append('${param.name}', new Blob([fs.readFileSync('${param.fileName}')]), '${param.fileName}')
`;
          } else if (param.value !== void 0) {
            prefix += `formData.append('${param.name}', '${param.value}')
`;
          }
        });
        prefix += "\n";
        options.body = new Unquoted("formData");
      } else if (mimeType === "application/x-www-form-urlencoded" && params) {
        const form = Object.fromEntries(params.map((p) => [p.name, p.value]));
        options.body = new Unquoted(`new URLSearchParams(${objectToString(form)})`);
      } else {
        options.body = normalizedRequest.postData.text;
      }
    }
    const jsonOptions = Object.keys(options).length ? `, ${objectToString(options)}` : "";
    return `${prefix}fetch('${normalizedRequest.url}${queryString}'${jsonOptions})`;
  }
};
export {
  nodeFetch
};
//# sourceMappingURL=fetch.js.map
