import { objectToString } from "../../../utils/objectToString.js";
const nodeOfetch = {
  target: "node",
  client: "ofetch",
  title: "ofetch",
  generate(request) {
    const normalizedRequest = {
      method: "GET",
      ...request
    };
    normalizedRequest.method = normalizedRequest.method.toUpperCase();
    const options = {
      method: normalizedRequest.method === "GET" ? void 0 : normalizedRequest.method
    };
    options.query = normalizedRequest.queryString;
    if (normalizedRequest.headers?.length) {
      options.headers = {};
      normalizedRequest.headers.forEach((header) => {
        options.headers[header.name] = header.value;
      });
    }
    if (normalizedRequest.cookies?.length) {
      options.headers = options.headers || {};
      normalizedRequest.cookies.forEach((cookie) => {
        options.headers["Set-Cookie"] = options.headers["Set-Cookie"] ? `${options.headers["Set-Cookie"]}; ${cookie.name}=${cookie.value}` : `${cookie.name}=${cookie.value}`;
      });
    }
    Object.keys(options).forEach((key) => {
      if (options[key] === void 0) {
        delete options[key];
      }
    });
    if (normalizedRequest.postData) {
      options.body = normalizedRequest.postData.text;
      if (normalizedRequest.postData.mimeType === "application/json") {
        options.body = JSON.parse(options.body);
      }
    }
    const jsonOptions = Object.keys(options).length ? `, ${objectToString(options)}` : "";
    return `import { ofetch } from 'ofetch'

ofetch('${normalizedRequest.url}'${jsonOptions})`;
  }
};
export {
  nodeOfetch
};
//# sourceMappingURL=ofetch.js.map
