import { createSearchParams } from "../../../utils/create-search-params.js";
import { objectToString, Unquoted } from "../../../utils/objectToString.js";
const nodeUndici = {
  target: "node",
  client: "undici",
  title: "undici",
  generate(request) {
    const normalizedRequest = {
      method: "GET",
      ...request
    };
    normalizedRequest.method = normalizedRequest.method.toUpperCase();
    const options = {
      method: normalizedRequest.method === "GET" ? void 0 : normalizedRequest.method
    };
    const searchParams = createSearchParams(normalizedRequest.queryString);
    const queryString = searchParams.size ? `?${searchParams.toString()}` : "";
    if (normalizedRequest.headers?.length) {
      options.headers = {};
      normalizedRequest.headers.forEach((header) => {
        options.headers[header.name] = header.value;
      });
    }
    if (normalizedRequest.cookies?.length) {
      options.headers = options.headers || {};
      normalizedRequest.cookies.forEach((cookie) => {
        options.headers["Set-Cookie"] = options.headers["Set-Cookie"] ? `${options.headers["Set-Cookie"]}; ${cookie.name}=${cookie.value}` : `${cookie.name}=${cookie.value}`;
      });
    }
    Object.keys(options).forEach((key) => {
      if (options[key] === void 0) {
        delete options[key];
      }
    });
    if (normalizedRequest.postData) {
      options.body = normalizedRequest.postData.text;
      if (normalizedRequest.postData.mimeType === "application/json") {
        options.body = new Unquoted(`JSON.stringify(${objectToString(JSON.parse(options.body))})`);
      }
    }
    const jsonOptions = Object.keys(options).length ? `, ${objectToString(options)}` : "";
    return `import { request } from 'undici'

const { statusCode, body } = await request('${normalizedRequest.url}${queryString}'${jsonOptions})`;
  }
};
export {
  nodeUndici
};
//# sourceMappingURL=undici.js.map
