/**
 * Represents a raw code that should not be quoted, e.g. `JSON.stringify(...)`.
 * If consists of multiple lines, they will be indented properly.
 */
export declare class Unquoted {
    value: string;
    constructor(value: string);
}
/**
 * Converts an object into a string representation with proper formatting and indentation
 *
 * Handles nested objects, arrays, and special string values
 */
export declare function objectToString(obj: Record<string, any>, indent?: number): string;
//# sourceMappingURL=objectToString.d.ts.map