"use strict";const a=`/* basic theme */
.light-mode {
  --scalar-color-1: #2a2f45;
  --scalar-color-2: #757575;
  --scalar-color-3: #8e8e8e;
  --scalar-color-accent: #7070ff;

  --scalar-background-1: #fff;
  --scalar-background-2: #f6f6f6;
  --scalar-background-3: #e7e7e7;
  --scalar-background-accent: #7070ff1f;

  --scalar-border-color: rgba(0, 0, 0, 0.1);

  --scalar-code-language-color-supersede: var(--scalar-color-3);
}
.dark-mode {
  --scalar-color-1: #f7f8f8;
  --scalar-color-2: rgb(180, 188, 208);
  --scalar-color-3: #b4bcd099;
  --scalar-color-accent: #828fff;

  --scalar-background-1: #000212;
  --scalar-background-2: #0d0f1e;
  --scalar-background-3: #232533;
  --scalar-background-accent: #8ab4f81f;

  --scalar-border-color: #313245;
  --scalar-code-language-color-supersede: var(--scalar-color-3);
}
/* Document Sidebar */
.light-mode .t-doc__sidebar {
  --scalar-sidebar-background-1: var(--scalar-background-1);
  --scalar-sidebar-item-hover-color: currentColor;
  --scalar-sidebar-item-hover-background: var(--scalar-background-2);
  --scalar-sidebar-item-active-background: var(--scalar-background-accent);
  --scalar-sidebar-border-color: var(--scalar-border-color);
  --scalar-sidebar-color-1: var(--scalar-color-1);
  --scalar-sidebar-color-2: var(--scalar-color-2);
  --scalar-sidebar-color-active: var(--scalar-color-accent);
  --scalar-sidebar-search-background: rgba(0, 0, 0, 0.05);
  --scalar-sidebar-search-border-color: 1px solid rgba(0, 0, 0, 0.05);
  --scalar-sidebar-search-color: var(--scalar-color-3);
  --scalar-background-2: rgba(0, 0, 0, 0.03);
}
.dark-mode .t-doc__sidebar {
  --scalar-sidebar-background-1: var(--scalar-background-1);
  --scalar-sidebar-item-hover-color: currentColor;
  --scalar-sidebar-item-hover-background: var(--scalar-background-2);
  --scalar-sidebar-item-active-background: rgba(255, 255, 255, 0.1);
  --scalar-sidebar-border-color: var(--scalar-border-color);
  --scalar-sidebar-color-1: var(--scalar-color-1);
  --scalar-sidebar-color-2: var(--scalar-color-2);
  --scalar-sidebar-color-active: var(--scalar-color-accent);
  --scalar-sidebar-search-background: rgba(255, 255, 255, 0.1);
  --scalar-sidebar-search-border-color: 1px solid rgba(255, 255, 255, 0.05);
  --scalar-sidebar-search-color: var(--scalar-color-3);
}
/* advanced */
.light-mode {
  --scalar-color-green: #069061;
  --scalar-color-red: #ef0006;
  --scalar-color-yellow: #edbe20;
  --scalar-color-blue: #0082d0;
  --scalar-color-orange: #fb892c;
  --scalar-color-purple: #5203d1;

  --scalar-button-1: rgba(0, 0, 0, 1);
  --scalar-button-1-hover: rgba(0, 0, 0, 0.8);
  --scalar-button-1-color: rgba(255, 255, 255, 0.9);
}
.dark-mode {
  --scalar-color-green: #00b648;
  --scalar-color-red: #dc1b19;
  --scalar-color-yellow: #ffc90d;
  --scalar-color-blue: #4eb3ec;
  --scalar-color-orange: #ff8d4d;
  --scalar-color-purple: #b191f9;

  --scalar-button-1: rgba(255, 255, 255, 1);
  --scalar-button-1-hover: rgba(255, 255, 255, 0.9);
  --scalar-button-1-color: black;
}
/* Custom Theme */
.dark-mode h2.t-editor__heading,
.dark-mode .t-editor__page-title h1,
.dark-mode h1.section-header:not(::selection),
.dark-mode .markdown h1,
.dark-mode .markdown h2,
.dark-mode .markdown h3,
.dark-mode .markdown h4,
.dark-mode .markdown h5,
.dark-mode .markdown h6 {
  -webkit-text-fill-color: transparent;
  background-image: linear-gradient(to right bottom, rgb(255, 255, 255) 30%, rgba(255, 255, 255, 0.38));
  -webkit-background-clip: text;
  background-clip: text;
}
.sidebar-search {
  backdrop-filter: blur(12px);
}
@keyframes headerbackground {
  from {
    background: transparent;
    backdrop-filter: none;
  }
  to {
    background: var(--header-background-1);
    backdrop-filter: blur(12px);
  }
}
.dark-mode .scalar-card {
  background: rgba(255, 255, 255, 0.05) !important;
}
.dark-mode .scalar-card * {
  --scalar-background-2: transparent !important;
  --scalar-background-1: transparent !important;
}
.light-mode .dark-mode.scalar-card *,
.light-mode .dark-mode.scalar-card {
  --scalar-background-1: #0d0f1e !important;
  --scalar-background-2: #0d0f1e !important;
  --scalar-background-3: #191b29 !important;
}
.light-mode .dark-mode.scalar-card {
  background: #191b29 !important;
}
.badge {
  box-shadow: 0 0 0 1px var(--scalar-border-color);
  margin-right: 6px;
}

.table-row.required-parameter .table-row-item:nth-of-type(2):after {
  background: transparent;
  box-shadow: none;
}
/* Hero Section Flare */
.section-flare {
  width: 100vw;
  background: radial-gradient(ellipse 80% 50% at 50% -20%, rgba(120, 119, 198, 0.3), transparent);
  height: 100vh;
}
.light-mode *::selection {
  background-color: color-mix(in srgb, var(--scalar-color-accent), transparent 70%);
}
.dark-mode *::selection {
  background-color: color-mix(in srgb, var(--scalar-color-accent), transparent 50%);
}
`;module.exports=a;
