"use strict";const a=`/* basic theme */
.light-mode {
  color-scheme: light;
  --scalar-color-1: #322b3b;
  --scalar-color-2: #645676;
  --scalar-color-3: #9789a9;
  --scalar-color-accent: #40b4c4;

  --scalar-background-1: #fff;
  --scalar-background-2: #f4f2f7;
  --scalar-background-3: #cfc7dc;
  --scalar-background-accent: #f3fafb;

  --scalar-border-color: #e4e0eb;
}
.dark-mode {
  color-scheme: dark;
  --scalar-color-1: #fff;
  --scalar-color-2: #b8b6ba;
  --scalar-color-3: #706c74;
  --scalar-color-accent: #ed78c2;

  --scalar-background-1: #27212e;
  --scalar-background-2: #322c39;
  --scalar-background-3: #4c4059;
  --scalar-background-accent: #eb64b91f;

  --scalar-border-color: rgba(255, 255, 255, 0.1);
}

/* Document header */
.light-mode .t-doc__header {
  --scalar-header-background-1: var(--scalar-background-1);
  --scalar-header-border-color: var(--scalar-border-color);
  --scalar-header-color-1: var(--scalar-color-1);
  --scalar-header-color-2: var(--scalar-color-2);
  --scalar-header-background-toggle: var(--scalar-color-3);
  --scalar-header-call-to-action-color: var(--scalar-color-accent);
}

.dark-mode .t-doc__header {
  --scalar-header-background-1: var(--scalar-background-1);
  --scalar-header-border-color: var(--scalar-border-color);
  --scalar-header-color-1: var(--scalar-color-1);
  --scalar-header-color-2: var(--scalar-color-2);
  --scalar-header-background-toggle: var(--scalar-color-3);
  --scalar-header-call-to-action-color: var(--scalar-color-accent);
}

/* Sidebar */
.light-mode .t-doc__sidebar {
  --scalar-sidebar-background-1: var(--scalar-background-1);
  --scalar-sidebar-item-hover-color: currentColor;
  --scalar-sidebar-item-hover-background: var(--scalar-background-2);
  --scalar-sidebar-item-active-background: var(--scalar-background-accent);
  --scalar-sidebar-border-color: var(--scalar-border-color);
  --scalar-sidebar-color-1: var(--scalar-color-1);
  --scalar-sidebar-color-2: var(--scalar-color-2);
  --scalar-sidebar-color-active: var(--scalar-color-accent);
  --scalar-sidebar-search-background: var(--scalar-background-2);
  --scalar-sidebar-search-border-color: var(--scalar-sidebar-border-color);
  --scalar-sidebar-search--color: var(--scalar-color-3);
}
.dark-mode .t-doc__sidebar {
  --scalar-sidebar-background-1: var(--scalar-background-1);
  --scalar-sidebar-item-hover-color: currentColor;
  --scalar-sidebar-item-hover-background: var(--scalar-background-2);
  --scalar-sidebar-item-active-background: var(--scalar-background-accent);
  --scalar-sidebar-border-color: var(--scalar-border-color);
  --scalar-sidebar-color-1: var(--scalar-color-1);
  --scalar-sidebar-color-2: var(--scalar-color-2);
  --scalar-sidebar-color-active: var(--scalar-color-accent);
  --scalar-sidebar-search-background: var(--scalar-background-2);
  --scalar-sidebar-search-border-color: #514c56;
  --scalar-sidebar-search--color: var(--scalar-color-3);
}
/* advanced */
.light-mode {
  --scalar-button-1: rgb(49 53 56);
  --scalar-button-1-color: #fff;
  --scalar-button-1-hover: rgb(28 31 33);

  --scalar-color-green: #74dfc4;
  --scalar-color-red: #d887f5;
  --scalar-color-yellow: #ffe261;
  --scalar-color-blue: #40b4c4;
  --scalar-color-orange: #ff52bf;
  --scalar-color-purple: #91889b;

  --scalar-scrollbar-color: rgba(0, 0, 0, 0.18);
  --scalar-scrollbar-color-active: rgba(0, 0, 0, 0.36);
}
.dark-mode {
  --scalar-button-1: #f6f6f6;
  --scalar-button-1-color: #27212e;
  --scalar-button-1-hover: #e7e7e7;

  --scalar-color-green: #74dfc4;
  --scalar-color-red: #d887f5;
  --scalar-color-yellow: #ffe261;
  --scalar-color-blue: #40b4c4;
  --scalar-color-orange: #ff52bf;
  --scalar-color-purple: #91889b;

  --scalar-scrollbar-color: rgba(255, 255, 255, 0.24);
  --scalar-scrollbar-color-active: rgba(255, 255, 255, 0.48);
}
/* Radius */
:root {
  --scalar-radius: 2px;
  --scalar-radius-lg: 3px;
  --scalar-radius-xl: 4px;
}
/* P3 color support */
@supports (color: color(display-p3 1 1 1)) {
  .light-mode {
    --scalar-color-accent: color(display-p3 0.25098 0.705882 0.768627 / 1.0);
    --scalar-color-green: color(display-p3 0.454902 0.87451 0.768627 / 1.0);
    --scalar-color-red: color(display-p3 0.847059 0.529412 0.960784 / 1.0);
    --scalar-color-yellow: color(display-p3 1.0 0.886275 0.380392 / 1.0);
    --scalar-color-blue: color(display-p3 0.25098 0.705882 0.768627 / 1.0);
    --scalar-color-orange: color(display-p3 1.0 0.321569 0.74902 / 1.0);
    --scalar-color-purple: color(display-p3 0.568627 0.533333 0.607843 / 1.0);
  }
  .dark-mode {
    --scalar-color-accent: color(display-p3 0.929412 0.470588 0.760784 / 1.0);
    --scalar-color-green: color(display-p3 0.454902 0.87451 0.768627 / 1.0);
    --scalar-color-red: color(display-p3 0.847059 0.529412 0.960784 / 1.0);
    --scalar-color-yellow: color(display-p3 1.0 0.886275 0.380392 / 1.0);
    --scalar-color-blue: color(display-p3 0.25098 0.705882 0.768627 / 1.0);
    --scalar-color-orange: color(display-p3 1.0 0.321569 0.74902 / 1.0);
    --scalar-color-purple: color(display-p3 0.568627 0.533333 0.607843 / 1.0);
  }
}
`;module.exports=a;
