const a = `.light-mode {
  color-scheme: light;
  --scalar-color-1: #000000;
  --scalar-color-2: #000000;
  --scalar-color-3: #000000;
  --scalar-color-accent: #645b0f;
  --scalar-background-1: #ccc9b3;
  --scalar-background-2: #c2bfaa;
  --scalar-background-3: #b8b5a1;
  --scalar-background-accent: #000000;

  --scalar-border-color: rgba(0, 0, 0, 0.2);
  --scalar-scrollbar-color: rgba(0, 0, 0, 0.18);
  --scalar-scrollbar-color-active: rgba(0, 0, 0, 0.36);
  --scalar-lifted-brightness: 1;
  --scalar-backdrop-brightness: 1;

  --scalar-shadow-1: 0 1px 3px 0 rgba(0, 0, 0, 0.11);
  --scalar-shadow-2: rgba(0, 0, 0, 0.08) 0px 13px 20px 0px, rgba(0, 0, 0, 0.08) 0px 3px 8px 0px,
    var(--scalar-border-color) 0px 0 0 1px;

  --scalar-button-1: rgb(49 53 56);
  --scalar-button-1-color: #fff;
  --scalar-button-1-hover: rgb(28 31 33);

  --scalar-color-red: #b91c1c;
  --scalar-color-orange: #a16207;
  --scalar-color-green: #047857;
  --scalar-color-blue: #1d4ed8;
  --scalar-color-orange: #c2410c;
  --scalar-color-purple: #6d28d9;
}

.dark-mode {
  color-scheme: dark;
  --scalar-color-1: #fffef3;
  --scalar-color-2: #fffef3;
  --scalar-color-3: #fffef3;
  --scalar-color-accent: #c3b531;
  --scalar-background-1: #313332;
  --scalar-background-2: #393b3a;
  --scalar-background-3: #414342;
  --scalar-background-accent: #fffef3;

  --scalar-border-color: #505452;
  --scalar-scrollbar-color: rgba(255, 255, 255, 0.24);
  --scalar-scrollbar-color-active: rgba(255, 255, 255, 0.48);
  --scalar-lifted-brightness: 1.45;
  --scalar-backdrop-brightness: 0.5;

  --scalar-shadow-1: 0 1px 3px 0 rgba(0, 0, 0, 0.11);
  --scalar-shadow-2: rgba(15, 15, 15, 0.2) 0px 3px 6px, rgba(15, 15, 15, 0.4) 0px 9px 24px, 0 0 0 1px
    rgba(255, 255, 255, 0.1);

  --scalar-button-1: #f6f6f6;
  --scalar-button-1-color: #000;
  --scalar-button-1-hover: #e7e7e7;

  --scalar-color-green: #00b648;
  --scalar-color-red: #dc1b19;
  --scalar-color-yellow: #ffc90d;
  --scalar-color-blue: #4eb3ec;
  --scalar-color-orange: #ff8d4d;
  --scalar-color-purple: #b191f9;
}

/* Sidebar */
.light-mode .t-doc__sidebar,
.dark-mode .t-doc__sidebar {
  --scalar-sidebar-background-1: var(--scalar-background-1);
  --scalar-sidebar-color-1: var(--scalar-color-1);
  --scalar-sidebar-color-2: var(--scalar-color-2);
  --scalar-sidebar-border-color: var(--scalar-border-color);

  --scalar-sidebar-item-hover-background: var(--scalar-background-2);
  --scalar-sidebar-item-hover-color: currentColor;

  --scalar-sidebar-item-active-background: var(--scalar-background-3);
  --scalar-sidebar-color-active: var(--scalar-color-1);

  --scalar-sidebar-search-background: transparent;
  --scalar-sidebar-search-color: var(--scalar-color-3);
  --scalar-sidebar-search-border-color: var(--scalar-border-color);
}
*::selection {
  background-color: color-mix(in srgb, var(--scalar-color-accent), transparent 80%);
}
`;
export {
  a as default
};
