/** Scalar Tailwind Preset */
declare const _default: {
    darkMode: ["selector", string];
    presets: {
        theme: {
            columns: {
                '3xs': string;
                '2xs': string;
                xs: string;
                sm: string;
                md: string;
                lg: string;
                xl: string;
                '2xl': string;
                '3xl': string;
                '4xl': string;
                '5xl': string;
                '6xl': string;
                '7xl': string;
            };
            spacing: {
                0: string;
                0.25: string;
                0.5: string;
                0.75: string;
                1: string;
                1.25: string;
                1.5: string;
                1.75: string;
                2: string;
                2.25: string;
                2.5: string;
                2.75: string;
                3: string;
                3.25: string;
                3.5: string;
                3.75: string;
                4: string;
                5: string;
                6: string;
                7: string;
                8: string;
                9: string;
                10: string;
                11: string;
                12: string;
                14: string;
                16: string;
                20: string;
                20.5: string;
                21: string;
                21.5: string;
                22: string;
                22.5: string;
                23: string;
                23.5: string;
                24: string;
                28: string;
                29: string;
                30: string;
                31: string;
                32: string;
                36: string;
                40: string;
                44: string;
                45: string;
                46: string;
                47: string;
                48: string;
                52: string;
                56: string;
                60: string;
                64: string;
                72: string;
                80: string;
                96: string;
            };
            lineHeight: {
                3: string;
                3.25: string;
                3.5: string;
                3.75: string;
                4: string;
                4.25: string;
                4.5: string;
                4.75: string;
                5: string;
                5.25: string;
                5.5: string;
                5.75: string;
                6: string;
                7: string;
                8: string;
                9: string;
                10: string;
            };
            maxWidth: () => {
                0: string;
                xs: string;
                sm: string;
                md: string;
                lg: string;
                xl: string;
                '2xl': string;
                '3xl': string;
                '4xl': string;
                '5xl': string;
                '6xl': string;
                '7xl': string;
                full: string;
                'min  ': string;
                max: string;
                fit: string;
            };
        };
    }[];
    theme: {
        borderRadius: {
            DEFAULT: string;
            md: string;
            lg: string;
            xl: string;
            px: string;
            full: string;
            none: string;
        };
        borderWidth: {
            DEFAULT: string;
            '0': string;
            '1/2': string;
            '1': string;
            '2': string;
            '4': string;
        };
        boxShadow: {
            DEFAULT: string;
            lg: string;
            md: string;
            sm: string;
            none: string;
            border: string;
            'border-1/2': string;
        };
        fontFamily: {
            DEFAULT: string;
            sans: string;
            code: string;
        };
        fontSize: {
            '3xs': string;
            xxs: string;
            xs: string;
            sm: string;
            base: string;
            lg: string;
            xl: string;
        };
        fontWeight: {
            DEFAULT: string;
            normal: string;
            medium: string;
            bold: string;
        };
        colors: {
            current: string;
            inherit: string;
            b: {
                1: string;
                1.5: string;
                2: string;
                3: string;
                4: string;
                accent: string;
                btn: string;
                danger: string;
                alert: string;
            };
            c: {
                1: string;
                2: string;
                3: string;
                accent: string;
                ghost: string;
                disabled: string;
                btn: string;
                danger: string;
                alert: string;
            };
            h: {
                btn: string;
            };
            sidebar: {
                b: {
                    1: string;
                };
                c: {
                    1: string;
                    2: string;
                };
                border: string;
            };
            backdrop: string;
            backdropdark: string;
            border: string;
            brand: string;
            green: string;
            red: string;
            yellow: string;
            blue: string;
            orange: string;
            purple: string;
            grey: string;
            indigo: string;
            pink: string;
            white: string;
            transparent: string;
        };
        lineHeight: {
            none: string;
            tight: string;
            snug: string;
            normal: string;
            relaxed: string;
            loose: string;
            DEFAULT: string;
            1: string;
            2: string;
            3: string;
            4: string;
            5: string;
        };
        screens: {
            /** Mobile */
            xs: string;
            /** Large Mobile */
            sm: string;
            /** Tablet */
            md: string;
            /** Desktop */
            lg: string;
            /** Ultrawide and larger */
            xl: string;
            /** Custom breakpoint for zoomed in screens (should trigger at about 200% zoom) */
            zoomed: {
                raw: string;
            };
        };
        zIndex: {
            '-1': string;
            '0': string;
            '1': string;
        };
        extend: {
            borderColor: {
                DEFAULT: string;
            };
            brightness: {
                lifted: string;
                backdrop: string;
            };
            spacing: {
                px: string;
                header: string;
                border: string;
            };
        };
    };
};
export default _default;
//# sourceMappingURL=tailwind.d.ts.map