const alternateTheme = "/* basic theme */\n:root {\n  --scalar-text-decoration: underline;\n  --scalar-text-decoration-hover: underline;\n}\n\n.dark-mode {\n  --scalar-background-1: #131313;\n  --scalar-background-2: #1d1d1d;\n  --scalar-background-3: #272727;\n  --scalar-background-card: #1d1d1d;\n\n  --scalar-color-1: rgba(255, 255, 255, 0.9);\n  --scalar-color-2: rgba(255, 255, 255, 0.62);\n  --scalar-color-3: rgba(255, 255, 255, 0.44);\n\n  --scalar-color-accent: var(--scalar-color-1);\n  --scalar-background-accent: var(--scalar-background-3);\n\n  --scalar-border-color: #2a2b2a;\n}\n\n.light-mode,\n.light-mode .dark-mode {\n  --scalar-background-1: #f9f9f9;\n  --scalar-background-2: #f1f1f1;\n  --scalar-background-3: #e7e7e7;\n  --scalar-background-card: #fff;\n\n  --scalar-color-1: #2a2f45;\n  --scalar-color-2: #757575;\n  --scalar-color-3: #8e8e8e;\n\n  --scalar-color-accent: var(--scalar-color-1);\n  --scalar-background-accent: var(--scalar-background-3);\n\n  --scalar-border-color: rgba(0, 0, 0, 0.1);\n}\n\n/* Document Sidebar */\n.t-doc__sidebar {\n  --scalar-color-green: var(--scalar-color-1);\n  --scalar-color-red: var(--scalar-color-1);\n  --scalar-color-yellow: var(--scalar-color-1);\n  --scalar-color-blue: var(--scalar-color-1);\n  --scalar-color-orange: var(--scalar-color-1);\n  --scalar-color-purple: var(--scalar-color-1);\n}\n\n.light-mode .t-doc__sidebar,\n.dark-mode .t-doc__sidebar {\n  --scalar-sidebar-background-1: var(--scalar-background-1);\n  --scalar-sidebar-color-1: var(--scalar-color-1);\n  --scalar-sidebar-color-2: var(--scalar-color-2);\n  --scalar-sidebar-border-color: var(--scalar-border-color);\n\n  --scalar-sidebar-item-hover-background: var(--scalar-background-2);\n  --scalar-sidebar-item-hover-color: currentColor;\n\n  --scalar-sidebar-item-active-background: var(--scalar-background-accent);\n  --scalar-sidebar-color-active: var(--scalar-color-accent);\n\n  --scalar-sidebar-search-background: transparent;\n  --scalar-sidebar-search-color: var(--scalar-color-3);\n  --scalar-sidebar-search-border-color: var(--scalar-border-color);\n}\n/* advanced */\n.light-mode .dark-mode,\n.light-mode {\n  --scalar-color-green: #069061;\n  --scalar-color-red: #ef0006;\n  --scalar-color-yellow: #edbe20;\n  --scalar-color-blue: #0082d0;\n  --scalar-color-orange: #fb892c;\n  --scalar-color-purple: #5203d1;\n\n  --scalar-button-1: rgba(0, 0, 0, 1);\n  --scalar-button-1-hover: rgba(0, 0, 0, 0.8);\n  --scalar-button-1-color: rgba(255, 255, 255, 0.9);\n}\n.dark-mode {\n  --scalar-color-green: #00b648;\n  --scalar-color-red: #dd2f2c;\n  --scalar-color-yellow: #ffc90d;\n  --scalar-color-blue: #4eb3ec;\n  --scalar-color-orange: #ff8d4d;\n  --scalar-color-purple: #b191f9;\n\n  --scalar-button-1: rgba(255, 255, 255, 1);\n  --scalar-button-1-hover: rgba(255, 255, 255, 0.9);\n  --scalar-button-1-color: black;\n}\n\n.scalar-api-client__item,\n.scalar-card,\n.dark-mode .dark-mode.scalar-card {\n  --scalar-background-1: var(--scalar-background-card);\n  --scalar-background-2: var(--scalar-background-1);\n  --scalar-background-3: var(--scalar-background-1);\n}\n.dark-mode .dark-mode.scalar-card {\n  --scalar-background-3: var(--scalar-background-3);\n}\n\n.light-mode *::selection {\n  background-color: color-mix(in srgb, var(--scalar-color-blue), transparent 70%);\n}\n.dark-mode *::selection {\n  background-color: color-mix(in srgb, var(--scalar-color-blue), transparent 50%);\n}\n";
export {
  alternateTheme as default
};
