const bluePlanetTheme = "/* basic theme */\n:root {\n  --scalar-text-decoration: underline;\n  --scalar-text-decoration-hover: underline;\n}\n.light-mode {\n  --scalar-background-1: #f0f2f5;\n  --scalar-background-2: #eaecf0;\n  --scalar-background-3: #e0e2e6;\n  --scalar-border-color: rgb(213 213 213);\n\n  --scalar-color-1: rgb(9, 9, 11);\n  --scalar-color-2: rgb(113, 113, 122);\n  --scalar-color-3: rgba(25, 25, 28, 0.5);\n\n  --scalar-color-accent: var(--scalar-color-1);\n  --scalar-background-accent: #8ab4f81f;\n}\n.light-mode .scalar-card.dark-mode,\n.dark-mode {\n  --scalar-background-1: #000e23;\n  --scalar-background-2: #01132e;\n  --scalar-background-3: #03193b;\n  --scalar-border-color: #2e394c;\n\n  --scalar-color-1: #fafafa;\n  --scalar-color-2: rgb(161, 161, 170);\n  --scalar-color-3: rgba(255, 255, 255, 0.533);\n\n  --scalar-color-accent: var(--scalar-color-1);\n  --scalar-background-accent: #8ab4f81f;\n\n  --scalar-code-language-color-supersede: var(--scalar-color-1);\n}\n/* Document Sidebar */\n.light-mode .t-doc__sidebar,\n.dark-mode .t-doc__sidebar {\n  --scalar-sidebar-background-1: var(--scalar-background-1);\n  --scalar-sidebar-color-1: var(--scalar-color-1);\n  --scalar-sidebar-color-2: var(--scalar-color-2);\n  --scalar-sidebar-border-color: var(--scalar-border-color);\n\n  --scalar-sidebar-item-hover-background: var(--scalar-background-2);\n  --scalar-sidebar-item-hover-color: currentColor;\n\n  --scalar-sidebar-item-active-background: var(--scalar-background-3);\n  --scalar-sidebar-color-active: var(--scalar-color-accent);\n\n  --scalar-sidebar-search-background: rgba(255, 255, 255, 0.1);\n  --scalar-sidebar-search-border-color: var(--scalar-border-color);\n  --scalar-sidebar-search-color: var(--scalar-color-3);\n  z-index: 1;\n}\n.light-mode .t-doc__sidebar {\n  --scalar-sidebar-search-background: white;\n}\n/* advanced */\n.light-mode {\n  --scalar-color-green: #069061;\n  --scalar-color-red: #ef0006;\n  --scalar-color-yellow: #edbe20;\n  --scalar-color-blue: #0082d0;\n  --scalar-color-orange: #fb892c;\n  --scalar-color-purple: #5203d1;\n\n  --scalar-button-1: rgba(0, 0, 0, 1);\n  --scalar-button-1-hover: rgba(0, 0, 0, 0.8);\n  --scalar-button-1-color: rgba(255, 255, 255, 0.9);\n}\n.dark-mode {\n  --scalar-color-green: rgba(69, 255, 165, 0.823);\n  --scalar-color-red: #ff8589;\n  --scalar-color-yellow: #ffcc4d;\n  --scalar-color-blue: #6bc1fe;\n  --scalar-color-orange: #f98943;\n  --scalar-color-purple: #b191f9;\n\n  --scalar-button-1: rgba(255, 255, 255, 1);\n  --scalar-button-1-hover: rgba(255, 255, 255, 0.9);\n  --scalar-button-1-color: black;\n}\n/* Custom theme */\n/* Document header */\n@keyframes headerbackground {\n  from {\n    background: transparent;\n    backdrop-filter: none;\n  }\n  to {\n    background: var(--scalar-header-background-1);\n    backdrop-filter: blur(12px);\n  }\n}\n\n.light-mode .t-doc__header,\n.dark-mode .t-doc__header {\n  animation: headerbackground forwards;\n  animation-timeline: scroll();\n  animation-range: 0px 200px;\n}\n\n/* Document Layout */\n.dark-mode .t-doc .layout-content {\n  background: transparent;\n}\n\n.dark-mode h2.t-editor__heading,\n.dark-mode .t-editor__page-title h1,\n.dark-mode h1.section-header:not(::selection),\n.dark-mode .markdown h1,\n.dark-mode .markdown h2,\n.dark-mode .markdown h3,\n.dark-mode .markdown h4,\n.dark-mode .markdown h5,\n.dark-mode .markdown h6 {\n  -webkit-text-fill-color: transparent;\n  background-image: linear-gradient(to right bottom, rgb(255, 255, 255) 30%, rgba(255, 255, 255, 0.38));\n  -webkit-background-clip: text;\n  background-clip: text;\n}\n/* Hero Section Flare */\n.section-flare-item:nth-of-type(1) {\n  --c1: #ffffff;\n  --c2: #babfd8;\n  --c3: #2e8bb2;\n  --c4: #1a8593;\n  --c5: #0a143e;\n  --c6: #0a0f52;\n  --c7: #2341b8;\n\n  --solid: var(--c1), var(--c2), var(--c3), var(--c4), var(--c5), var(--c6), var(--c7);\n  --solid-wrap: var(--solid), var(--c1);\n  --trans:\n    var(--c1), transparent, var(--c2), transparent, var(--c3),\n    transparent, var(--c4), transparent, var(--c5), transparent, var(--c6),\n    transparent, var(--c7);\n  --trans-wrap: var(--trans), transparent, var(--c1);\n\n  background: radial-gradient(circle, var(--trans)), conic-gradient(from 180deg, var(--trans-wrap)),\n    radial-gradient(circle, var(--trans)), conic-gradient(var(--solid-wrap));\n  width: 70vw;\n  height: 700px;\n  border-radius: 50%;\n  filter: blur(100px);\n  z-index: 0;\n  right: 0;\n  position: absolute;\n  transform: rotate(-45deg);\n  top: -300px;\n  opacity: 0.3;\n}\n.section-flare-item:nth-of-type(3) {\n  --star-color: #6b9acc;\n  --star-color2: #446b8d;\n  --star-color3: #3e5879;\n  background-image: radial-gradient(2px 2px at 20px 30px, var(--star-color2), rgba(0, 0, 0, 0)),\n    radial-gradient(2px 2px at 40px 70px, var(--star-color), rgba(0, 0, 0, 0)),\n    radial-gradient(2px 2px at 50px 160px, var(--star-color3), rgba(0, 0, 0, 0)),\n    radial-gradient(2px 2px at 90px 40px, var(--star-color), rgba(0, 0, 0, 0)),\n    radial-gradient(2px 2px at 130px 80px, var(--star-color), rgba(0, 0, 0, 0)),\n    radial-gradient(2px 2px at 160px 120px, var(--star-color3), rgba(0, 0, 0, 0));\n  background-repeat: repeat;\n  background-size: 200px 200px;\n  width: 100%;\n  height: 100%;\n  mask-image: radial-gradient(ellipse at 100% 0%, black 40%, transparent 70%);\n}\n.section-flare {\n  top: -150px !important;\n  height: 100vh;\n  background: linear-gradient(#000, var(--scalar-background-1));\n  width: 100vw;\n  overflow-x: hidden;\n}\n.light-mode .section-flare {\n  display: none;\n}\n.light-mode .scalar-card {\n  --scalar-background-1: #fff;\n  --scalar-background-2: #fff;\n  --scalar-background-3: #fff;\n}\n\n*::selection {\n  background-color: color-mix(in srgb, var(--scalar-color-blue), transparent 60%);\n}\n\n@media (max-width: 1000px) {\n  .light-mode .t-doc__sidebar,\n  .dark-mode .t-doc__sidebar {\n    --scalar-sidebar-background-1: var(--scalar-background-1);\n  }\n  .light-mode .t-doc__header,\n  .dark-mode .t-doc__header {\n    animation: none;\n    background: var(--scalar-header-background-1);\n    backdrop-filter: blur(12px);\n  }\n}\n";
export {
  bluePlanetTheme as default
};
