const customThemeStarter = '/**\n  Custom Theme Starter\n*/\n:root {\n  --scalar-border-width: 1px;\n  --scalar-radius: 3px;\n  --scalar-radius-lg: 6px;\n  --scalar-radius-xl: 8px;\n\n  --scalar-header-height: 50px;\n  --scalar-sidebar-width: 280px;\n  --scalar-toc-width: 280px;\n\n  /* Typography */\n  --scalar-font: "Inter", -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, Oxygen, Ubuntu, Cantarell, "Open Sans",\n    "Helvetica Neue", sans-serif;\n  --scalar-font-code: "JetBrains Mono";\n\n  /* Font sizes */\n  --scalar-heading-1: 24px; /* Page headings */\n  --scalar-page-description: 16px;\n  --scalar-heading-2: 20px; /* Section headings */\n  --scalar-heading-3: 20px;\n  --scalar-heading-4: 16px;\n  --scalar-heading-5: 16px;\n  --scalar-heading-6: 16px;\n\n  --scalar-paragraph: 16px;\n  --scalar-small: 14px;\n  --scalar-mini: 13px;\n  --scalar-micro: 12px;\n  --scalar-bold: 600;\n  --scalar-semibold: 500;\n  --scalar-regular: 400;\n}\n\n@media (max-width: 720px) {\n  :root {\n    --scalar-heading-1: 24px;\n    --scalar-page-description: 20px;\n  }\n}\n\n/* Color Theming */\n.light-mode {\n  color-scheme: light;\n  --scalar-color-1: #2a2f45;\n  --scalar-color-2: #757575;\n  --scalar-color-3: #8e8e8e;\n  --scalar-color-disabled: #b4b1b1;\n  --scalar-color-ghost: #a7a7a7;\n  --scalar-color-accent: #0099ff;\n  --scalar-background-1: #fff;\n  --scalar-background-2: #f6f6f6;\n  --scalar-background-3: #e7e7e7;\n  --scalar-background-4: rgba(0, 0, 0, 0.06);\n  --scalar-background-accent: #8ab4f81f;\n\n  --scalar-border-color: rgba(0, 0, 0, 0.1);\n  --scalar-scrollbar-color: rgba(0, 0, 0, 0.18);\n  --scalar-scrollbar-color-active: rgba(0, 0, 0, 0.36);\n  --scalar-lifted-brightness: 1;\n  --scalar-backdrop-brightness: 1;\n\n  --scalar-shadow-1: 0 1px 3px 0 rgba(0, 0, 0, 0.11);\n  --scalar-shadow-2: rgba(0, 0, 0, 0.08) 0px 13px 20px 0px, rgba(0, 0, 0, 0.08) 0px 3px 8px 0px, #eeeeed 0px 0 0 1px;\n\n  --scalar-button-1: rgb(49 53 56);\n  --scalar-button-1-color: #fff;\n  --scalar-button-1-hover: rgb(28 31 33);\n\n  --scalar-color-green: #059669;\n  --scalar-color-red: #dc2626;\n  --scalar-color-yellow: #ca8a04;\n  --scalar-color-blue: #2563eb;\n  --scalar-color-orange: #ea580c;\n  --scalar-color-purple: #7c3aed;\n}\n\n.dark-mode {\n  color-scheme: dark;\n  --scalar-color-1: rgba(255, 255, 255, 0.9);\n  --scalar-color-2: rgba(255, 255, 255, 0.62);\n  --scalar-color-3: rgba(255, 255, 255, 0.44);\n  --scalar-color-disabled: rgba(255, 255, 255, 0.34);\n  --scalar-color-ghost: rgba(255, 255, 255, 0.26);\n  --scalar-color-accent: #8ab4f8;\n  --scalar-background-1: #1a1a1a;\n  --scalar-background-2: #252525;\n  --scalar-background-3: #323232;\n  --scalar-background-4: rgba(255, 255, 255, 0.06);\n  --scalar-background-accent: #8ab4f81f;\n\n  --scalar-border-color: rgba(255, 255, 255, 0.1);\n  --scalar-scrollbar-color: rgba(255, 255, 255, 0.24);\n  --scalar-scrollbar-color-active: rgba(255, 255, 255, 0.48);\n  --scalar-lifted-brightness: 1.45;\n  --scalar-backdrop-brightness: 0.5;\n\n  --scalar-shadow-1: 0 1px 3px 0 rgb(0, 0, 0, 0.1);\n  --scalar-shadow-2: rgba(15, 15, 15, 0.2) 0px 3px 6px, rgba(15, 15, 15, 0.4) 0px 9px 24px, 0 0 0 1px\n    rgba(255, 255, 255, 0.1);\n\n  --scalar-button-1: #f6f6f6;\n  --scalar-button-1-color: #000;\n  --scalar-button-1-hover: #e7e7e7;\n\n  --scalar-color-green: #00b648;\n  --scalar-color-red: #dc1b19;\n  --scalar-color-yellow: #ffc90d;\n  --scalar-color-blue: #4eb3ec;\n  --scalar-color-orange: #ff8d4d;\n  --scalar-color-purple: #b191f9;\n}\n\n/* Aliases & Inferred Variables */\n.light-mode,\n.dark-mode {\n  --scalar-border: var(--scalar-border-width) solid var(--scalar-border-color);\n}\n\n/* Sidebar */\n.light-mode .t-doc__sidebar {\n  --scalar-sidebar-background-1: var(--scalar-background-1);\n  --scalar-sidebar-item-hover-color: currentColor;\n  --scalar-sidebar-item-hover-background: var(--scalar-background-2);\n  --scalar-sidebar-item-active-background: var(--scalar-background-accent);\n  --scalar-sidebar-border-color: var(--scalar-border-color);\n  --scalar-sidebar-color-1: var(--scalar-color-1);\n  --scalar-sidebar-color-2: var(--scalar-color-2);\n  --scalar-sidebar-color-active: var(--scalar-color-accent);\n  --scalar-sidebar-search-background: transparent;\n  --scalar-sidebar-search-border-color: var(--scalar-sidebar-border-color);\n  --scalar-sidebar-search--color: var(--scalar-color-3);\n}\n\n.dark-mode .t-doc__sidebar {\n  --scalar-sidebar-background-1: var(--scalar-background-1);\n  --scalar-sidebar-item-hover-color: currentColor;\n  --scalar-sidebar-item-hover-background: var(--scalar-background-2);\n  --scalar-sidebar-item-active-background: var(--scalar-background-accent);\n  --scalar-sidebar-border-color: var(--scalar-border-color);\n  --scalar-sidebar-color-1: var(--scalar-color-1);\n  --scalar-sidebar-color-2: var(--scalar-color-2);\n  --scalar-sidebar-color-active: var(--scalar-color-accent);\n  --scalar-sidebar-search-background: transparent;\n  --scalar-sidebar-search-border-color: var(--scalar-sidebar-border-color);\n  --scalar-sidebar-search--color: var(--scalar-color-3);\n}\n\n/* Table of contents */\n.light-mode .t-doc__toc {\n  --table-of-contents-heading-color: var(--scalar-color-1);\n  --table-of-contents-section-color: var(--scalar-color-2);\n  --table-of-contents-section-color-active: var(--scalar-color-accent);\n}\n.dark-mode .t-doc__toc {\n  --table-of-contents-heading-color: var(--scalar-color-1);\n  --table-of-contents-section-color: var(--scalar-color-2);\n  --table-of-contents-section-color-active: var(--scalar-color-accent);\n}\n\n/* Document header */\n.light-mode .t-doc__header {\n  --scalar-header-background-1: var(--scalar-background-1);\n  --scalar-header-border-color: var(--scalar-border-color);\n  --scalar-header-color-1: var(--scalar-color-1);\n  --scalar-header-color-2: var(--scalar-color-2);\n  --scalar-header-background-toggle: var(--scalar-color-3);\n  --scalar-header-call-to-action-color: var(--scalar-color-accent);\n}\n\n.dark-mode .t-doc__header {\n  --scalar-header-background-1: var(--scalar-background-1);\n  --scalar-header-border-color: var(--scalar-border-color);\n  --scalar-header-color-1: var(--scalar-color-1);\n  --scalar-header-color-2: var(--scalar-color-2);\n  --scalar-header-background-toggle: var(--scalar-color-3);\n  --scalar-header-call-to-action-color: var(--scalar-color-accent);\n}\n\n/* --- Document Typography --- */\n\n/* Page Title */\n.t-editor__page-title {\n  --font-size: var(--scalar-heading-1);\n  --font-color: var(--scalar-color-1);\n  --font-weight: var(--scalar-bold);\n}\n\n.t-editor__page-title .subheading {\n  --font-size: var(--scalar-page-description);\n  --font-color: var(--scalar-color-1);\n  --font-weight: var(--scalar-semibold);\n}\n\n/* Headings */\n.t-editor__heading h1 {\n  --font-size: var(--scalar-heading-2);\n  --font-weight: var(--scalar-bold);\n  --font-color: var(--scalar-color-1);\n}\n\n.t-editor__heading h2 {\n  --font-size: var(--scalar-heading-2);\n  --font-weight: var(--scalar-bold);\n  --font-color: var(--scalar-color-1);\n}\n\n.t-editor__heading h3 {\n  --font-size: var(--scalar-heading-3);\n  --font-color: var(--scalar-color-1);\n  --font-weight: var(--scalar-bold);\n}\n\n.t-editor__heading h4,\n.t-editor__heading h5,\n.t-editor__heading h6 {\n  --font-size: var(--scalar-heading-4);\n  --font-color: var(--scalar-color-1);\n  --font-weight: var(--scalar-bold);\n}\n\n/* Paragraph */\n.t-editor__paragraph {\n  --font-size: var(--scalar-paragraph);\n  --font-color: var(--scalar-color-1);\n  --font-weight: var(--scalar-regular);\n}\n\n/* Lists */\n.t-editor__list ul,\n.t-editor__list ol {\n  color: var(--scalar-color-1);\n  padding-left: 30px;\n}\n\n/* Checklist */\n.t-editor__checklist ul {\n  list-style: none;\n  padding-left: 0;\n  margin-left: 0;\n}\n\n/* Blockquote */\n.t-editor__quote {\n  --font-size: var(--scalar-paragraph);\n  --scalar-border-left: 2px solid var(--scalar-color-1);\n  --font-color: var(--scalar-color-1);\n  --padding: 6px 0 6px 14px;\n}\n\n/* Fine print */\n.t-editor__fine-print {\n  --font-size: var(--scalar-mini);\n  --font-color: var(--scalar-color-2);\n  --font-weight: var(--scalar-regular);\n}\n\n/* Bold */\n.t-editor__bold {\n  font-weight: var(--scalar-bold);\n}\n\n/* Italics */\n.t-editor__italic {\n  font-style: italic;\n}\n\n/* Underline */\n.t-editor__underline {\n  text-decoration: underline;\n}\n\n/* Highlight */\n.t-editor__highlight {\n  background-color: var(--highlight-background);\n  color: var(--highlight-color);\n}\n\n/* Links */\n.t-editor__anchor {\n  --font-color: var(--scalar-color-accent);\n  --font-visited: var(--scalar-color-2);\n  --font-hover: var(--scalar-color-accent);\n  --text-decoration: none;\n  --text-decoration-hover: underline;\n}\n\n/* Strike-through */\n.t-editor__strike {\n  text-decoration: line-through;\n}\n\n/* Inline code */\n.t-editor__inline-code {\n}\n\n/* Mark */\n.t-editor__mark {\n  --highlight-color: var(--scalar-color-1);\n  --highlight-background: #2297ff38;\n}\n\n/* --- Document Blocks --- */\n\n/* Buttons */\n.t-editor__button {\n  --font-size: var(--scalar-small);\n  --font-weight: var(--scalar-semibold);\n  --button-border-radius: var(--scalar-radius);\n  --button-padding: 8px 12px;\n  --button-text-decoration: none;\n}\n\n.light-mode .t-editor__button {\n  --font-color: var(--scalar-button-1-color);\n  --font-color-hover: var(--scalar-button-1-color);\n  --button-background: var(--scalar-button-1);\n  --button-background-hover: var(--scalar-button-1-hover);\n  --button-border-color: var(--scalar-button-1);\n  --button-border-color-hover: var(--scalar-button-1-hover);\n}\n\n.dark-mode .t-editor__button {\n  --font-color: var(--scalar-button-1-color);\n  --font-color-hover: var(--scalar-button-1-color);\n  --button-background: var(--scalar-button-1);\n  --button-background-hover: var(--scalar-button-1-hover);\n  --button-border-color: var(--scalar-button-1);\n  --button-border-color-hover: var(--scalar-button-1-hover);\n}\n\n/* Callout */\n.dark-mode .t-editor__callout {\n  --callout-font-size: var(--scalar-paragraph);\n\n  --callout-neutral-primary: var(--scalar-border-color);\n  --callout-neutral-secondary: var(--scalar-background-2);\n  --callout-neutral-font-color: var(--scalar-color-1);\n\n  --callout-success-primary: #5dce89;\n  --callout-success-secondary: rgba(93, 206, 137, 0.08);\n  --callout-success-font-color: var(--scalar-color-1);\n\n  --callout-danger-primary: #da615d;\n  --callout-danger-secondary: rgba(218, 97, 93, 0.08);\n  --callout-danger-font-color: var(--scalar-color-1);\n\n  --callout-warning-primary: #ffbb5c;\n  --callout-warning-secondary: rgba(255, 187, 92, 0.08);\n  --callout-warning-font-color: var(--scalar-color-1);\n\n  --callout-info-primary: #586ee0;\n  --callout-info-secondary: rgba(88, 110, 224, 0.08);\n  --callout-info-font-color: var(--scalar-color-1);\n}\n.light-mode .t-editor__callout {\n  --callout-font-size: var(--scalar-paragraph);\n\n  --callout-neutral-primary: var(--scalar-border-color);\n  --callout-neutral-secondary: var(--scalar-background-2);\n  --callout-neutral-font-color: var(--scalar-color-1);\n\n  --callout-success-primary: #5dce89;\n  --callout-success-secondary: rgba(93, 206, 137, 0.08);\n  --callout-success-font-color: var(--scalar-color-1);\n\n  --callout-danger-primary: #da615d;\n  --callout-danger-secondary: rgba(218, 97, 93, 0.08);\n  --callout-danger-font-color: var(--scalar-color-1);\n\n  --callout-warning-primary: #ffbb5c;\n  --callout-warning-secondary: rgba(255, 187, 92, 0.08);\n  --callout-warning-font-color: var(--scalar-color-1);\n\n  --callout-info-primary: #586ee0;\n  --callout-info-secondary: rgba(88, 110, 224, 0.08);\n  --callout-info-font-color: var(--scalar-color-1);\n}\n\n/* Codeblock */\n.t-editor__code {\n}\n\n/* Image Embed */\n.t-editor__image {\n}\n\n/* Custom embed */\n.t-editor__embed {\n}\n\n/* Custom file upload */\n.t-editor__file {\n}\n\n/* Page link */\n.t-editor__page-link {\n  box-shadow: var(--scalar-shadow-1);\n  border-radius: var(--scalar-radius);\n  background: var(--scalar-background-2);\n  padding: 16px;\n  position: relative;\n  cursor: pointer;\n  display: flex;\n  align-items: center;\n  justify-content: space-between;\n}\n\n/* Line break */\n.t-editor__line-break {\n}\n\n/* Math */\n.t-editor__math {\n  --font-color: var(--scalar-color-2);\n  --font-size: var(--scalar-mini);\n  --font-weight: var(--scalar-regular);\n}\n\n/* Tables */\n.t-editor__table table {\n}\n';
export {
  customThemeStarter as default
};
