const deepSpaceTheme = '/* basic theme */\n:root {\n  --scalar-text-decoration: underline;\n  --scalar-text-decoration-hover: underline;\n}\n.light-mode {\n  --scalar-color-1: rgb(9, 9, 11);\n  --scalar-color-2: rgb(113, 113, 122);\n  --scalar-color-3: rgba(25, 25, 28, 0.5);\n  --scalar-color-accent: var(--scalar-color-1);\n\n  --scalar-background-1: #fff;\n  --scalar-background-2: #f4f4f5;\n  --scalar-background-3: #e3e3e6;\n  --scalar-background-accent: #8ab4f81f;\n\n  --scalar-border-color: rgb(228, 228, 231);\n  --scalar-code-language-color-supersede: var(--scalar-color-1);\n}\n.dark-mode {\n  --scalar-color-1: #fafafa;\n  --scalar-color-2: rgb(161, 161, 170);\n  --scalar-color-3: rgba(255, 255, 255, 0.533);\n  --scalar-color-accent: var(--scalar-color-1);\n\n  --scalar-background-1: #09090b;\n  --scalar-background-2: #18181b;\n  --scalar-background-3: #2c2c30;\n  --scalar-background-accent: #8ab4f81f;\n\n  --scalar-border-color: rgba(255, 255, 255, 0.16);\n  --scalar-code-language-color-supersede: var(--scalar-color-1);\n}\n\n/* Document Sidebar */\n.light-mode .t-doc__sidebar,\n.dark-mode .t-doc__sidebar {\n  --scalar-sidebar-background-1: var(--scalar-background-1);\n  --scalar-sidebar-color-1: var(--scalar-color-1);\n  --scalar-sidebar-color-2: var(--scalar-color-2);\n  --scalar-sidebar-border-color: var(--scalar-border-color);\n\n  --scalar-sidebar-item-hover-color: currentColor;\n  --scalar-sidebar-item-hover-background: var(--scalar-background-2);\n\n  --scalar-sidebar-item-active-background: var(--scalar-background-3);\n  --scalar-sidebar-color-active: var(--scalar-color-accent);\n\n  --scalar-sidebar-search-background: transparent;\n  --scalar-sidebar-search-border-color: var(--scalar-border-color);\n  --scalar-sidebar-search-color: var(--scalar-color-3);\n}\n.light-mode .t-doc__sidebar {\n  --scalar-sidebar-item-active-background: var(--scalar-background-2);\n}\n/* advanced */\n.light-mode {\n  --scalar-color-green: #069061;\n  --scalar-color-red: #ef0006;\n  --scalar-color-yellow: #edbe20;\n  --scalar-color-blue: #0082d0;\n  --scalar-color-orange: #fb892c;\n  --scalar-color-purple: #5203d1;\n\n  --scalar-button-1: rgba(0, 0, 0, 1);\n  --scalar-button-1-hover: rgba(0, 0, 0, 0.8);\n  --scalar-button-1-color: rgba(255, 255, 255, 0.9);\n}\n.dark-mode {\n  --scalar-color-green: rgba(69, 255, 165, 0.823);\n  --scalar-color-red: #ff8589;\n  --scalar-color-yellow: #ffcc4d;\n  --scalar-color-blue: #6bc1fe;\n  --scalar-color-orange: #f98943;\n  --scalar-color-purple: #b191f9;\n\n  --scalar-button-1: rgba(255, 255, 255, 1);\n  --scalar-button-1-hover: rgba(255, 255, 255, 0.9);\n  --scalar-button-1-color: black;\n}\n/* Custom theme */\n.dark-mode h2.t-editor__heading,\n.dark-mode .t-editor__page-title h1,\n.dark-mode h1.section-header:not(::selection),\n.dark-mode .markdown h1,\n.dark-mode .markdown h2,\n.dark-mode .markdown h3,\n.dark-mode .markdown h4,\n.dark-mode .markdown h5,\n.dark-mode .markdown h6 {\n  -webkit-text-fill-color: transparent;\n  background-image: linear-gradient(to right bottom, rgb(255, 255, 255) 30%, rgba(255, 255, 255, 0.38));\n  -webkit-background-clip: text;\n  background-clip: text;\n}\n.examples .scalar-card-footer {\n  --scalar-background-3: transparent;\n  padding-top: 0;\n}\n/* Hero section flare */\n.section-flare {\n  width: 100vw;\n  height: 550px;\n  position: absolute;\n}\n.section-flare-item:nth-of-type(1) {\n  position: absolute;\n  width: 100vw;\n  height: 550px;\n  --stripesDark: repeating-linear-gradient(100deg, #000 0%, #000 7%, transparent 10%, transparent 12%, #000 16%);\n  --rainbow: repeating-linear-gradient(100deg, #fff 10%, #fff 16%, #fff 22%, #fff 30%);\n  background-image: var(--stripesDark), var(--rainbow);\n  background-size: 300%, 200%;\n  background-position: 50% 50%, 50% 50%;\n  filter: invert(100%);\n  -webkit-mask-image: radial-gradient(ellipse at 100% 0%, black 40%, transparent 70%);\n  mask-image: radial-gradient(ellipse at 100% 0%, black 40%, transparent 70%);\n  pointer-events: none;\n  opacity: 0.07;\n}\n.dark-mode .section-flare-item:nth-of-type(1) {\n  background-image: var(--stripesDark), var(--rainbow);\n  filter: opacity(50%) saturate(200%);\n  opacity: 0.25;\n  height: 350px;\n}\n.section-flare-item:nth-of-type(1):after {\n  content: "";\n  position: absolute;\n  top: 0;\n  right: 0;\n  bottom: 0;\n  left: 0;\n  background-image: var(--stripesDark), var(--rainbow);\n  background-size: 200%, 100%;\n  background-attachment: fixed;\n  mix-blend-mode: difference;\n}\n.dark-mode .section-flare:after {\n  background-image: var(--stripesDark), var(--rainbow);\n}\n.section-flare-item:nth-of-type(2) {\n  --star-color: #fff;\n  --star-color2: #fff;\n  --star-color3: #fff;\n  width: 100%;\n  height: 100%;\n  position: absolute;\n  background-image: radial-gradient(2px 2px at 20px 30px, var(--star-color2), rgba(0, 0, 0, 0)),\n    radial-gradient(2px 2px at 40px 70px, var(--star-color), rgba(0, 0, 0, 0)),\n    radial-gradient(2px 2px at 50px 160px, var(--star-color3), rgba(0, 0, 0, 0)),\n    radial-gradient(2px 2px at 90px 40px, var(--star-color), rgba(0, 0, 0, 0)),\n    radial-gradient(2px 2px at 130px 80px, var(--star-color), rgba(0, 0, 0, 0)),\n    radial-gradient(2px 2px at 160px 120px, var(--star-color3), rgba(0, 0, 0, 0));\n  background-repeat: repeat;\n  background-size: 200px 200px;\n  mask-image: radial-gradient(ellipse at 100% 0%, black 40%, transparent 70%);\n  opacity: 0.2;\n}\n.light-mode *::selection {\n  background-color: color-mix(in srgb, var(--scalar-color-blue), transparent 70%);\n}\n.dark-mode *::selection {\n  background-color: color-mix(in srgb, var(--scalar-color-blue), transparent 50%);\n}\n\n/* document header */\n.light-mode .t-doc__header,\n.dark-mode .t-doc__header {\n  animation: headerbackground forwards;\n  animation-timeline: scroll();\n  animation-range: 0px 200px;\n}\n@keyframes headerbackground {\n  from {\n    background: transparent;\n    backdrop-filter: none;\n  }\n  to {\n    background: var(--scalar-header-background-1);\n    backdrop-filter: blur(12px);\n  }\n}\n/* remove flare on safari to prevent dropped frames on scroll */\n@supports (-webkit-hyphens: none) {\n  .section-flare {\n    display: none;\n  }\n}\n\n/* document background */\n.light-mode .t-doc .layout-content,\n.dark-mode .t-doc .layout-content {\n  background: transparent;\n}\n';
export {
  deepSpaceTheme as default
};
