const elysiajsTheme = '.light-mode {\n  --scalar-color-1: #2a2f45;\n  --scalar-color-2: #757575;\n  --scalar-color-3: #8e8e8e;\n  --scalar-color-accent: #f06292;\n\n  --scalar-background-1: #fff;\n  --scalar-background-2: #f6f6f6;\n  --scalar-background-3: #e7e7e7;\n\n  --scalar-border-color: rgba(0, 0, 0, 0.1);\n}\n.dark-mode {\n  --scalar-color-1: rgba(255, 255, 255, 0.9);\n  --scalar-color-2: rgba(156, 163, 175, 1);\n  --scalar-color-3: rgba(255, 255, 255, 0.44);\n  --scalar-color-accent: #f06292;\n\n  --scalar-background-1: #111728;\n  --scalar-background-2: #1e293b;\n  --scalar-background-3: #334155;\n  --scalar-background-accent: #f062921f;\n\n  --scalar-border-color: rgba(255, 255, 255, 0.1);\n}\n\n/* Document Sidebar */\n.light-mode .t-doc__sidebar,\n.dark-mode .t-doc__sidebar {\n  --scalar-sidebar-background-1: var(--scalar-background-1);\n  --scalar-sidebar-color-1: var(--scalar-color-1);\n  --scalar-sidebar-color-2: var(--scalar-color-2);\n  --scalar-sidebar-border-color: var(--scalar-border-color);\n\n  --scalar-sidebar-item-hover-background: var(--scalar-background-2);\n  --scalar-sidebar-item-hover-color: currentColor;\n\n  --scalar-sidebar-item-active-background: #f062921f;\n  --scalar-sidebar-color-active: var(--scalar-color-accent);\n\n  --scalar-sidebar-search-background: transparent;\n  --scalar-sidebar-search-color: var(--scalar-color-3);\n  --scalar-sidebar-search-border-color: var(--scalar-border-color);\n}\n\n/* advanced */\n.light-mode {\n  --scalar-button-1: rgb(49 53 56);\n  --scalar-button-1-color: #fff;\n  --scalar-button-1-hover: rgb(28 31 33);\n\n  --scalar-color-green: #069061;\n  --scalar-color-red: #ef0006;\n  --scalar-color-yellow: #edbe20;\n  --scalar-color-blue: #0082d0;\n  --scalar-color-orange: #fb892c;\n  --scalar-color-purple: #5203d1;\n\n  --scalar-scrollbar-color: rgba(0, 0, 0, 0.18);\n  --scalar-scrollbar-color-active: rgba(0, 0, 0, 0.36);\n}\n.dark-mode {\n  --scalar-button-1: #f6f6f6;\n  --scalar-button-1-color: #000;\n  --scalar-button-1-hover: #e7e7e7;\n\n  --scalar-color-green: #a3ffa9;\n  --scalar-color-red: #ffa3a3;\n  --scalar-color-yellow: #fffca3;\n  --scalar-color-blue: #a5d6ff;\n  --scalar-color-orange: #e2ae83;\n  --scalar-color-purple: #d2a8ff;\n\n  --scalar-scrollbar-color: rgba(255, 255, 255, 0.24);\n  --scalar-scrollbar-color-active: rgba(255, 255, 255, 0.48);\n}\n.section-flare {\n  width: 100%;\n  height: 400px;\n  position: absolute;\n}\n.section-flare-item:first-of-type:before {\n  content: "";\n  position: absolute;\n  top: 0;\n  right: 0;\n  bottom: 0;\n  left: 0;\n  --stripes: repeating-linear-gradient(100deg, #fff 0%, #fff 0%, transparent 2%, transparent 12%, #fff 17%);\n  --stripesDark: repeating-linear-gradient(100deg, #000 0%, #000 0%, transparent 10%, transparent 12%, #000 17%);\n  --rainbow: repeating-linear-gradient(100deg, #60a5fa 10%, #e879f9 16%, #5eead4 22%, #60a5fa 30%);\n  contain: strict;\n  contain-intrinsic-size: 100vw 40vh;\n  background-image: var(--stripesDark), var(--rainbow);\n  background-size: 300%, 200%;\n  background-position: 50% 50%, 50% 50%;\n  filter: opacity(20%) saturate(200%);\n  -webkit-mask-image: radial-gradient(ellipse at 100% 0%, black 40%, transparent 70%);\n  mask-image: radial-gradient(ellipse at 100% 0%, black 40%, transparent 70%);\n  pointer-events: none;\n}\n.section-flare-item:first-of-type:after {\n  content: "";\n  position: absolute;\n  top: 0;\n  right: 0;\n  bottom: 0;\n  left: 0;\n  background-image: var(--stripes), var(--rainbow);\n  background-size: 200%, 100%;\n  background-attachment: fixed;\n  mix-blend-mode: difference;\n  background-image: var(--stripesDark), var(--rainbow);\n  pointer-events: none;\n}\n.light-mode .section-flare-item:first-of-type:after,\n.light-mode .section-flare-item:first-of-type:before {\n  background-image: var(--stripes), var(--rainbow);\n  filter: opacity(4%) saturate(200%);\n}\n';
export {
  elysiajsTheme as default
};
