const marsTheme = "/* basic theme */\n:root {\n  --scalar-text-decoration: underline;\n  --scalar-text-decoration-hover: underline;\n}\n.light-mode {\n  --scalar-background-1: #f9f6f0;\n  --scalar-background-2: #f2efe8;\n  --scalar-background-3: #e9e7e2;\n  --scalar-border-color: rgba(203, 165, 156, 0.6);\n\n  --scalar-color-1: #c75549;\n  --scalar-color-2: #c75549;\n  --scalar-color-3: #c75549;\n\n  --scalar-color-accent: #c75549;\n  --scalar-background-accent: #dcbfa81f;\n\n  --scalar-code-language-color-supersede: var(--scalar-color-1);\n}\n.dark-mode {\n  --scalar-background-1: #140507;\n  --scalar-background-2: #20090c;\n  --scalar-background-3: #321116;\n  --scalar-border-color: #3c3031;\n\n  --scalar-color-1: rgba(255, 255, 255, 0.9);\n  --scalar-color-2: rgba(255, 255, 255, 0.62);\n  --scalar-color-3: rgba(255, 255, 255, 0.44);\n\n  --scalar-color-accent: rgba(255, 255, 255, 0.9);\n  --scalar-background-accent: #441313;\n\n  --scalar-code-language-color-supersede: var(--scalar-color-1);\n}\n\n/* Document Sidebar */\n.light-mode .t-doc__sidebar,\n.dark-mode .t-doc__sidebar {\n  --scalar-sidebar-background-1: var(--scalar-background-1);\n  --scalar-sidebar-color-1: var(--scalar-color-1);\n  --scalar-sidebar-color-2: var(--scalar-color-2);\n  --scalar-sidebar-border-color: var(--scalar-border-color);\n\n  --scalar-sidebar-item-hover-color: currentColor;\n  --scalar-sidebar-item-hover-background: var(--scalar-background-2);\n\n  --scalar-sidebar-item-active-background: var(--scalar-background-3);\n  --scalar-sidebar-color-active: var(--scalar-color-accent);\n\n  --scalar-sidebar-search-background: rgba(255, 255, 255, 0.1);\n  --scalar-sidebar-search-color: var(--scalar-color-3);\n  --scalar-sidebar-search-border-color: var(--scalar-border-color);\n  z-index: 1;\n}\n/* advanced */\n.light-mode {\n  --scalar-color-green: #09533a;\n  --scalar-color-red: #aa181d;\n  --scalar-color-yellow: #ab8d2b;\n  --scalar-color-blue: #19689a;\n  --scalar-color-orange: #b26c34;\n  --scalar-color-purple: #4c2191;\n\n  --scalar-button-1: rgba(0, 0, 0, 1);\n  --scalar-button-1-hover: rgba(0, 0, 0, 0.8);\n  --scalar-button-1-color: rgba(255, 255, 255, 0.9);\n}\n.dark-mode {\n  --scalar-color-green: rgba(69, 255, 165, 0.823);\n  --scalar-color-red: #ff8589;\n  --scalar-color-yellow: #ffcc4d;\n  --scalar-color-blue: #6bc1fe;\n  --scalar-color-orange: #f98943;\n  --scalar-color-purple: #b191f9;\n\n  --scalar-button-1: rgba(255, 255, 255, 1);\n  --scalar-button-1-hover: rgba(255, 255, 255, 0.9);\n  --scalar-button-1-color: black;\n}\n/* Custom Theme */\n.dark-mode h2.t-editor__heading,\n.dark-mode .t-editor__page-title h1,\n.dark-mode h1.section-header:not(::selection),\n.dark-mode .markdown h1,\n.dark-mode .markdown h2,\n.dark-mode .markdown h3,\n.dark-mode .markdown h4,\n.dark-mode .markdown h5,\n.dark-mode .markdown h6 {\n  -webkit-text-fill-color: transparent;\n  background-image: linear-gradient(to right bottom, rgb(255, 255, 255) 30%, rgba(255, 255, 255, 0.38));\n  -webkit-background-clip: text;\n  background-clip: text;\n}\n.light-mode .t-doc__sidebar {\n  --scalar-sidebar-search-background: white;\n}\n.examples .scalar-card-footer {\n  --scalar-background-3: transparent;\n  padding-top: 0;\n}\n/* Hero section flare */\n.section-flare {\n  overflow-x: hidden;\n  height: 100vh;\n  left: initial;\n}\n.section-flare-item:nth-of-type(1) {\n  background: #d25019;\n  position: relative;\n  top: -150px;\n  right: -400px;\n  width: 80vw;\n  height: 500px;\n  margin-top: -150px;\n  border-radius: 50%;\n  filter: blur(100px);\n  z-index: 0;\n}\n.light-mode .section-flare {\n  display: none;\n}\n*::selection {\n  background-color: color-mix(in srgb, var(--scalar-color-red), transparent 75%);\n}\n\n/* document layout */\n.dark-mode .t-doc .layout-content {\n  background: transparent;\n}\n";
export {
  marsTheme as default
};
