const purpleTheme = "/* basic theme */\n.light-mode {\n  --scalar-background-1: #fff;\n  --scalar-background-2: #f5f6f8;\n  --scalar-background-3: #eceef1;\n\n  --scalar-color-1: #2a2f45;\n  --scalar-color-2: #757575;\n  --scalar-color-3: #8e8e8e;\n\n  --scalar-color-accent: #5469d4;\n  --scalar-background-accent: #5469d41f;\n\n  --scalar-border-color: rgba(215, 215, 206, 0.68);\n}\n.dark-mode {\n  --scalar-background-1: #15171c;\n  --scalar-background-2: #1c1e24;\n  --scalar-background-3: #22252b;\n\n  --scalar-color-1: #fafafa;\n  --scalar-color-2: #c9ced8;\n  --scalar-color-3: #8c99ad;\n\n  --scalar-color-accent: #5469d4;\n  --scalar-background-accent: #5469d41f;\n\n  --scalar-border-color: #3f4145;\n}\n/* Document Sidebar */\n.light-mode .t-doc__sidebar,\n.dark-mode .t-doc__sidebar {\n  --scalar-sidebar-background-1: var(--scalar-background-1);\n  --scalar-sidebar-color-1: var(--scalar-color-1);\n  --scalar-sidebar-color-2: var(--scalar-color-2);\n  --scalar-sidebar-border-color: var(--scalar-border-color);\n\n  --scalar-sidebar-item-hover-color: currentColor;\n  --scalar-sidebar-item-hover-background: var(--scalar-background-3);\n\n  --scalar-sidebar-item-active-background: var(--scalar-background-accent);\n  --scalar-sidebar-color-active: var(--scalar-color-accent);\n\n  --scalar-sidebar-search-background: var(--scalar-background-1);\n  --scalar-sidebar-search-color: var(--scalar-color-3);\n  --scalar-sidebar-search-border-color: var(--scalar-border-color);\n}\n\n/* advanced */\n.light-mode {\n  --scalar-color-green: #17803d;\n  --scalar-color-red: #e10909;\n  --scalar-color-yellow: #edbe20;\n  --scalar-color-blue: #1763a6;\n  --scalar-color-orange: #e25b09;\n  --scalar-color-purple: #5c3993;\n\n  --scalar-button-1: rgba(0, 0, 0, 1);\n  --scalar-button-1-hover: rgba(0, 0, 0, 0.8);\n  --scalar-button-1-color: rgba(255, 255, 255, 0.9);\n}\n.dark-mode {\n  --scalar-color-green: #30a159;\n  --scalar-color-red: #dc1b19;\n  --scalar-color-yellow: #eec644;\n  --scalar-color-blue: #2b7abf;\n  --scalar-color-orange: #f07528;\n  --scalar-color-purple: #7a59b1;\n\n  --scalar-button-1: rgba(255, 255, 255, 1);\n  --scalar-button-1-hover: rgba(255, 255, 255, 0.9);\n  --scalar-button-1-color: black;\n}\n.light-mode *::selection {\n  background-color: color-mix(in srgb, var(--scalar-color-accent), transparent 70%);\n}\n.dark-mode *::selection {\n  background-color: color-mix(in srgb, var(--scalar-color-accent), transparent 50%);\n}\n";
export {
  purpleTheme as default
};
